/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.utils.PatternMatching;

public class SpellCastCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_cast");
    public static final SpellCastCriteria INSTANCE = new SpellCastCriteria();

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public void trigger(ServerPlayer player, Holder<Spell> spell) {
        this.trigger(player, condition -> condition.matches(spell));
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<String> spell, Optional<String> other_spell) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)Codec.optionalField((String)"spell", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::spell), (App)Codec.optionalField((String)"other_spell", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::other_spell)).apply((Applicative)instance, Condition::new));

        public boolean matches(Holder<Spell> spellEntry) {
            String pattern;
            if (this.spell().isEmpty() && this.other_spell().isEmpty()) {
                return true;
            }
            if (this.spell().isPresent() && PatternMatching.matches(spellEntry, SpellRegistry.KEY, pattern = this.spell().get())) {
                return true;
            }
            return this.other_spell().isPresent() && PatternMatching.matches(spellEntry, SpellRegistry.KEY, pattern = this.other_spell().get());
        }
    }
}

