/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.arrow;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Collection;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.arrow.ArrowShootContext;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ProjectileWeaponItem.class})
public class RangedWeaponItemMixin {
    @WrapOperation(method={"shoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;Ljava/util/List;FFZLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ProjectileWeaponItem;createProjectile(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Z)Lnet/minecraft/world/entity/projectile/Projectile;")})
    private Projectile shootAll_wrap_createArrowEntity(ProjectileWeaponItem instance, Level world, LivingEntity shooter, ItemStack weaponStack, ItemStack projectileStack, boolean critical, Operation<Projectile> original) {
        Projectile projectile = (Projectile)original.call(new Object[]{instance, world, shooter, weaponStack, projectileStack, critical});
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (projectile instanceof ArrowExtension) {
                ArrowExtension arrow = (ArrowExtension)projectile;
                SpellCasterEntity caster = (SpellCasterEntity)player;
                ArrowShootContext shotContext = caster.getArrowShootContext();
                Supplier trackers = Suppliers.memoize(() -> PlayerLookup.tracking((Entity)shooter));
                for (Holder<Spell> spellEntry : shotContext.activeSpells) {
                    ArrowHelper.onArrowShot(arrow, shooter, spellEntry, (java.util.function.Supplier<Collection<ServerPlayer>>)trackers);
                }
                boolean firedBySpell = shotContext.firedBySpell;
                SpellTriggers.onArrowShot(arrow, player, firedBySpell);
            }
        }
        return projectile;
    }
}

