/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.delivery.Beam;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityVisualMixin
implements BeamEmitterEntity {
    @Nullable
    public Beam.Rendered lastRenderedBeam;

    private LivingEntity livingEntity() {
        return (LivingEntity)this;
    }

    @Override
    public void setLastRenderedBeam(Beam.Rendered beam) {
        this.lastRenderedBeam = beam;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick_TAIL_spawnBeamParticles(CallbackInfo ci) {
        LivingEntity livingEntity = this.livingEntity();
        Spell.Target.Beam beam = null;
        if (livingEntity instanceof SpellCasterEntity) {
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            beam = caster.getBeam();
        }
        Beam.Rendered renderedBeam = this.lastRenderedBeam;
        if (livingEntity.level().isClientSide && beam != null && renderedBeam != null) {
            Beam.Position position = renderedBeam.position();
            Spell.Target.Beam appearance = renderedBeam.appearance();
            float yaw = livingEntity.getYRot();
            if (position.hitBlock()) {
                for (ParticleBatch batch : appearance.block_hit_particles) {
                    ParticleHelper.play(livingEntity.level(), livingEntity.tickCount, position.end(), appearance.width * 2.0f, yaw, livingEntity.getXRot(), batch, (Entity)livingEntity);
                }
            }
        }
    }

    @Inject(method={"tickEffects()V"}, at={@At(value="TAIL")})
    private void tickStatusEffects_TAIL_SpellEngine_CustomParticles(CallbackInfo ci) {
        LivingEntity livingEntity = this.livingEntity();
        if (!livingEntity.isAlive() || !livingEntity.level().isClientSide()) {
            return;
        }
        for (Synchronized.Effect entry : Synchronized.effectsOf(livingEntity)) {
            MobEffect effect = entry.effect();
            int amplifier = entry.amplifier();
            CustomParticleStatusEffect.Spawner spawner = CustomParticleStatusEffect.spawnerOf(effect);
            if (spawner == null) continue;
            spawner.spawnParticles(livingEntity, amplifier);
        }
    }
}

