/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.entity;

import com.google.gson.Gson;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.arrow.ArrowShootContext;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCastSyncHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=555)
public class PlayerEntityMixin
implements SpellCasterEntity {
    private final SpellCooldownManager spellCooldownManager = new SpellCooldownManager(this.player());
    private static final EntityDataAccessor<String> SPELL_ENGINE_SPELL_PROGRESS = SynchedEntityData.defineId(Player.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final Gson syncGson = new Gson();
    private SpellCast.Process synchronizedSpellCastProcess = null;
    private int channelTickIndex = 0;
    private ArrowShootContext arrowShotContext = ArrowShootContext.EMPTY;
    private String lastHandledSyncData = "";

    private Player player() {
        return (Player)this;
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine_SyncEffects(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(SPELL_ENGINE_SPELL_PROGRESS, (Object)"");
    }

    @Override
    public void setSpellCastProcess(@Nullable SpellCast.Process process) {
        if (process != null && ((Spell)process.spell().value()).active == null) {
            return;
        }
        this.synchronizedSpellCastProcess = process;
        String json = process != null ? process.fastSyncJSON() : "";
        this.player().getEntityData().set(SPELL_ENGINE_SPELL_PROGRESS, (Object)json);
    }

    @Override
    public void setChannelTickIndex(int channelTickIndex) {
        this.channelTickIndex = channelTickIndex;
    }

    @Override
    public int getChannelTickIndex() {
        return this.channelTickIndex;
    }

    @Override
    @Nullable
    public SpellCast.Process getSpellCastProcess() {
        return this.synchronizedSpellCastProcess;
    }

    @Override
    public Spell getCurrentSpell() {
        SpellCast.Process process = this.getSpellCastProcess();
        if (process != null) {
            return (Spell)process.spell().value();
        }
        return null;
    }

    @Override
    public float getCurrentCastingSpeed() {
        SpellCast.Process process = this.getSpellCastProcess();
        if (process != null) {
            return process.speed();
        }
        return 1.0f;
    }

    @Override
    public void setArrowShootContext(ArrowShootContext shotContext) {
        this.arrowShotContext = shotContext;
    }

    @Override
    public ArrowShootContext getArrowShootContext() {
        return this.arrowShotContext;
    }

    @Override
    public SpellCooldownManager getCooldownManager() {
        return this.spellCooldownManager;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void tick_TAIL_SpellEngine(CallbackInfo ci) {
        int castTicks;
        Player player = this.player();
        if (player.level().isClientSide) {
            ((AnimatablePlayer)this.player()).updateSpellCastAnimationsOnTick();
            String progressString = (String)player.getEntityData().get(SPELL_ENGINE_SPELL_PROGRESS);
            if (!progressString.equals(this.lastHandledSyncData)) {
                if (progressString.isEmpty()) {
                    this.synchronizedSpellCastProcess = null;
                } else {
                    SpellCast.Process.SyncFormat syncFormat = (SpellCast.Process.SyncFormat)syncGson.fromJson(progressString, SpellCast.Process.SyncFormat.class);
                    this.synchronizedSpellCastProcess = SpellCast.Process.fromSync(player.level(), syncFormat, player.getMainHandItem().getItem(), player.level().getGameTime());
                }
                this.lastHandledSyncData = progressString;
            }
        } else if (this.synchronizedSpellCastProcess != null && (double)(castTicks = this.synchronizedSpellCastProcess.spellCastTicksSoFar(player.level().getGameTime())) >= (double)this.synchronizedSpellCastProcess.length() * 1.5) {
            SpellCastSyncHelper.clearCasting(player);
        }
        this.spellCooldownManager.tickUpdate();
    }

    @Override
    public boolean isBeaming() {
        return this.getBeam() != null;
    }

    @Override
    @Nullable
    public Spell.Target.Beam getBeam() {
        Spell spell = this.getCurrentSpell();
        if (spell != null && spell.target != null && spell.target.type == Spell.Target.Type.BEAM) {
            return spell.target.beam;
        }
        return null;
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt_TAIL_SpellEngine(CompoundTag nbt, CallbackInfo ci) {
        this.spellCooldownManager.writeCustomDataToNbt(nbt);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt_TAIL_SpellEngine(CompoundTag nbt, CallbackInfo ci) {
        this.spellCooldownManager.readCustomDataFromNbt(nbt);
    }
}

