/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.spell_engine.spellbinding.SpellBinding;

public class SpellBindingCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = SpellBinding.ID;
    public static final SpellBindingCriteria INSTANCE = new SpellBindingCriteria();

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public void trigger(ServerPlayer player, ResourceLocation spellPoolId, boolean isComplete) {
        this.trigger(player, condition -> condition.matches(spellPoolId, isComplete));
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<String> spell_pool, Optional<Boolean> complete) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)Codec.optionalField((String)"spell_pool", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::spell_pool), (App)Codec.optionalField((String)"complete", (Codec)Codec.BOOL, (boolean)true).forGetter(Condition::complete)).apply((Applicative)instance, Condition::new));

        public boolean matches(ResourceLocation usedSpellPool, boolean isComplete) {
            boolean poolMatches = true;
            if (this.spell_pool.isPresent()) {
                poolMatches = this.spell_pool.get().equals(usedSpellPool.toString());
            }
            if (this.complete.isPresent()) {
                poolMatches = poolMatches && this.complete.get() == isComplete;
            }
            return poolMatches;
        }
    }
}

