/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.spell_engine.api.config.AttributeModifier;

public class ConfigUtil {
    public static ItemAttributeModifiers.Builder attributesComponent(ResourceLocation modifierId, List<AttributeModifier> attributesConfig) {
        ItemAttributeModifiers.Builder componentBuilder = ItemAttributeModifiers.builder();
        List<Entry> modifiers = ConfigUtil.modifiersFrom(modifierId, attributesConfig);
        for (Entry modifier : modifiers) {
            componentBuilder.add(modifier.attribute(), modifier.modifier(), EquipmentSlotGroup.ANY);
        }
        return componentBuilder;
    }

    public static List<Entry> modifiersFrom(ResourceLocation modifierId, List<AttributeModifier> attributesConfig) {
        ArrayList<Entry> modifiers = new ArrayList<Entry>();
        for (AttributeModifier modifier : attributesConfig) {
            ResourceLocation attributeId = ResourceLocation.parse((String)modifier.attribute);
            Optional attribute = BuiltInRegistries.ATTRIBUTE.getHolder(attributeId);
            if (attribute.isPresent()) {
                ResourceLocation id = modifier.id != null && !modifier.id.isEmpty() ? ResourceLocation.parse((String)modifier.id) : modifierId;
                modifiers.add(new Entry((Holder<Attribute>)((Holder)attribute.get()), new net.minecraft.world.entity.ai.attributes.AttributeModifier(id, (double)modifier.value, modifier.operation)));
                continue;
            }
            System.err.println("Failed to resolve EntityAttribute with id: " + modifier.attribute);
        }
        return modifiers;
    }

    public record Entry(Holder<Attribute> attribute, net.minecraft.world.entity.ai.attributes.AttributeModifier modifier) {
    }
}

