/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.EntityActionsAllowed;

public class StatusEffectClassification {
    private static final Set<Holder<Attribute>> movementImpairingAttributes = new HashSet<Holder<Attribute>>();
    private static final Set<ResourceKey<MobEffect>> movementImpairingEffects = new HashSet<ResourceKey<MobEffect>>();

    public static void init() {
        movementImpairingAttributes.add((Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        movementImpairingAttributes.add((Holder<Attribute>)Attributes.FLYING_SPEED);
        movementImpairingAttributes.add((Holder<Attribute>)Attributes.GRAVITY);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> StatusEffectClassification.parse((Registry<MobEffect>)BuiltInRegistries.MOB_EFFECT));
    }

    private static void parse(Registry<MobEffect> registry) {
        registry.holders().forEach(entry -> {
            MobEffect effect = (MobEffect)entry.value();
            effect.createModifiers(0, (attribute, modifier) -> {
                if (movementImpairingAttributes.contains(attribute)) {
                    boolean isMovementImpairing = false;
                    double treshold = 0.0;
                    switch (modifier.operation()) {
                        case ADD_VALUE: 
                        case ADD_MULTIPLIED_BASE: {
                            treshold = 0.0;
                            break;
                        }
                        case ADD_MULTIPLIED_TOTAL: {
                            treshold = 1.0;
                        }
                    }
                    if (modifier.amount() < treshold) {
                        isMovementImpairing = true;
                    }
                    if (isMovementImpairing) {
                        movementImpairingEffects.add((ResourceKey<MobEffect>)((ResourceKey)entry.unwrapKey().get()));
                    }
                }
            });
        });
    }

    public static boolean isMovementImpairing(Holder<MobEffect> effect) {
        Optional key = effect.unwrapKey();
        if (key.isEmpty()) {
            return false;
        }
        return movementImpairingEffects.contains(key.get());
    }

    public static boolean disablesMobAI(Holder<MobEffect> effectEntry) {
        MobEffect effect = (MobEffect)effectEntry.value();
        EntityActionsAllowed actionsAllowed = ((ActionImpairing)effect).actionsAllowed();
        if (actionsAllowed == null) {
            return false;
        }
        return !actionsAllowed.mobs().canUseAI();
    }
}

