/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.entity;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import org.jetbrains.annotations.Nullable;

public class SpellEngineAttributes {
    public static final String NAMESPACE = "spell_engine";
    public static final ArrayList<Entry> all = new ArrayList();
    public static Entry HEALING_TAKEN = SpellEngineAttributes.add(new Entry("healing_taken", 0.0, 100.0, false));
    public static Entry DAMAGE_TAKEN = SpellEngineAttributes.add(new Entry("damage_taken", 0.0, 100.0, false)).category(Attribute.Sentiment.NEGATIVE);
    public static Entry EVASION_CHANCE = SpellEngineAttributes.add(new Entry("evasion_chance", 0.0, 100.0, false));

    public static Entry add(Entry entry) {
        all.add(entry);
        return entry;
    }

    public static void register() {
        all.forEach(Entry::register);
    }

    public static class Entry {
        public final ResourceLocation id;
        public final String translationKey;
        public final Attribute attribute;
        public final double baseValue;
        @Nullable
        public Holder<Attribute> entry;

        public Entry(String name, double minValue, double baseValue, boolean tracked) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)SpellEngineAttributes.NAMESPACE, (String)name);
            this.translationKey = "attribute.name.spell_engine." + name;
            this.attribute = new RangedAttribute(this.translationKey, baseValue, minValue, 2048.0).setSyncable(tracked);
            this.baseValue = baseValue;
        }

        public Entry category(Attribute.Sentiment category) {
            this.attribute.setSentiment(category);
            return this;
        }

        public double asMultiplier(double attributeValue) {
            return attributeValue / this.baseValue;
        }

        public double asChance(double attributeValue) {
            return (attributeValue - this.baseValue) / this.baseValue;
        }

        public void register() {
            this.entry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)this.attribute);
        }
    }
}

