/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.Platform;
import net.spell_engine.client.render.CustomModelRegistry;
import net.spell_engine.mixin.client.render.ItemRendererAccessor;

public class CustomModels {
    public static void registerModelIds(List<ResourceLocation> ids) {
        CustomModelRegistry.modelIds.addAll(ids);
    }

    public static void render(RenderType renderLayer, ItemRenderer itemRenderer, ResourceLocation modelId, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int seed) {
        ItemStack stack;
        ModelManager manager = Minecraft.getInstance().getModelManager();
        BakedModel model = Platform.Fabric ? manager.getModel(modelId) : manager.getModel(new ModelResourceLocation(modelId, "standalone"));
        if (model == null && !(stack = ((Item)BuiltInRegistries.ITEM.get(modelId)).getDefaultInstance()).isEmpty()) {
            model = itemRenderer.getModel(stack, null, null, seed);
        }
        CustomModels.renderModel(renderLayer, (ItemRendererAccessor)itemRenderer, matrices, vertexConsumers, light, model);
    }

    public static void renderModel(RenderType renderLayer, ItemRendererAccessor itemRenderer, PoseStack matrices, MultiBufferSource vertexConsumers, int light, BakedModel model) {
        VertexConsumer buffer = vertexConsumers.getBuffer(renderLayer);
        matrices.translate(-0.5, -0.5, -0.5);
        itemRenderer.SpellEngine_renderBakedItemModel(model, ItemStack.EMPTY, light, OverlayTexture.NO_OVERLAY, matrices, buffer);
    }
}

