/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class Drawable {

    public record Texture(ResourceLocation id, int width, int height) {
    }

    public record DrawRect(int u, int v, int width, int height) {
    }

    public record Component(DrawRect draw, Texture texture) {
        public void draw(GuiGraphics context, int x, int y, Anchor hAnchor, Anchor vAnchor) {
            switch (hAnchor.ordinal()) {
                case 0: {
                    break;
                }
                case 2: {
                    x -= this.draw().width / 2;
                    break;
                }
                case 1: {
                    x -= this.draw().width;
                }
            }
            switch (vAnchor.ordinal()) {
                case 0: {
                    break;
                }
                case 2: {
                    y -= this.draw().height / 2;
                    break;
                }
                case 1: {
                    y -= this.draw().height;
                }
            }
            context.blit(this.texture().id, x, y, (float)this.draw().u, (float)this.draw().v, this.draw().width, this.draw().height, this.texture().width, this.texture().height);
        }

        public void drawFlexibleWidth(GuiGraphics context, int x, int y, int width, Anchor vAnchor) {
            switch (vAnchor.ordinal()) {
                case 0: {
                    break;
                }
                case 2: {
                    y -= this.draw().height / 2;
                    break;
                }
                case 1: {
                    y -= this.draw().height;
                }
            }
            context.blit(this.texture().id, x, y, (float)this.draw().u, (float)this.draw().v, width, this.draw().height, this.texture().width, this.texture().height);
        }
    }

    public static enum Anchor {
        LEADING,
        TRAILING,
        CENTER;

    }
}

