/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.spell_engine.mixin.client.control.KeybindingAccessor;
import org.jetbrains.annotations.Nullable;

public class WrappedKeybinding {
    public KeyMapping original;
    public VanillaAlternative alternative;

    public WrappedKeybinding(KeyMapping original, VanillaAlternative alternative) {
        this.original = original;
        this.alternative = alternative;
    }

    @Nullable
    public Unwrapped get(Options options) {
        KeyMapping alternativeKey;
        InputConstants.Key assignedKey = ((KeybindingAccessor)this.original).spellEngine_getBoundKey();
        if (assignedKey != null && assignedKey.getValue() != InputConstants.UNKNOWN.getValue()) {
            return new Unwrapped(this.original, null);
        }
        if (this.alternative != null && (alternativeKey = this.alternative.keyBindingFrom(options)) != null) {
            return new Unwrapped(alternativeKey, this.alternative.category);
        }
        return null;
    }

    public static enum VanillaAlternative {
        NONE(null),
        USE_KEY(Category.USE_KEY),
        HOTBAR_KEY_1(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_2(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_3(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_4(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_5(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_6(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_7(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_8(Category.ITEM_HOTBAR_KEY),
        HOTBAR_KEY_9(Category.ITEM_HOTBAR_KEY);

        @Nullable
        public final Category category;

        private VanillaAlternative(Category category) {
            this.category = category;
        }

        @Nullable
        public KeyMapping keyBindingFrom(Options options) {
            return switch (this.ordinal()) {
                case 1 -> options.keyUse;
                case 2 -> options.keyHotbarSlots[0];
                case 3 -> options.keyHotbarSlots[1];
                case 4 -> options.keyHotbarSlots[2];
                case 5 -> options.keyHotbarSlots[3];
                case 6 -> options.keyHotbarSlots[4];
                case 7 -> options.keyHotbarSlots[5];
                case 8 -> options.keyHotbarSlots[6];
                case 9 -> options.keyHotbarSlots[7];
                case 10 -> options.keyHotbarSlots[8];
                default -> null;
            };
        }
    }

    public record Unwrapped(KeyMapping keyBinding, @Nullable Category vanillaHandle) {
    }

    public static enum Category {
        USE_KEY,
        ITEM_HOTBAR_KEY;

    }
}

