/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.arrow;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellModifiers;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.arrow.ArrowShootContext;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.mixin.item.RangedWeaponAccessor;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.WorldScheduler;

public class ArrowHelper {
    public static void shootArrow(Level world, LivingEntity shooter, Holder<Spell> spellEntry, SpellHelper.ImpactContext context) {
        ArrowHelper.shootArrow(world, shooter, spellEntry, context, 0);
    }

    public static void shootArrow(Level world, LivingEntity shooter, Holder<Spell> spellEntry, SpellHelper.ImpactContext context, int sequenceIndex) {
        Spell spell = (Spell)spellEntry.value();
        Spell.Delivery.ShootArrow shoot_arrow = spell.deliver.shoot_arrow;
        ItemStack weaponStack = shooter.getMainHandItem();
        Item weapon = Items.CROSSBOW;
        if (shoot_arrow != null && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (weapon instanceof ProjectileWeaponItem) {
                ItemStack ammo;
                ProjectileWeaponItem rangedWeapon = (ProjectileWeaponItem)weapon;
                Spell.LaunchProperties mutableLaunchProperties = shoot_arrow.launch_properties.copy();
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    List<Spell.Modifier> spellModifiers = SpellModifiers.of(player, spellEntry);
                    for (Spell.Modifier modifier : spellModifiers) {
                        if (modifier.projectile_launch == null) continue;
                        mutableLaunchProperties.mutatingCombine(modifier.projectile_launch);
                    }
                }
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    ammo = player.getProjectile(weaponStack);
                } else {
                    ammo = new ItemStack((ItemLike)Items.ARROW);
                }
                List<ItemStack> loadedAmmo = RangedWeaponAccessor.load_SpellEngine(weaponStack, ammo, shooter);
                if (loadedAmmo.isEmpty()) {
                    return;
                }
                if (shooter instanceof SpellCasterEntity) {
                    SpellCasterEntity caster = (SpellCasterEntity)shooter;
                    ArrowShootContext shotContext = new ArrowShootContext();
                    shotContext.firedBySpell = true;
                    shotContext.activeSpells.add(spellEntry);
                    caster.setArrowShootContext(shotContext);
                }
                float divergence = sequenceIndex == 0 ? 0.0f : shoot_arrow.divergence;
                ((RangedWeaponAccessor)rangedWeapon).shootAll_SpellEngine(serverWorld, shooter, InteractionHand.MAIN_HAND, weaponStack, loadedAmmo, shoot_arrow.launch_properties.velocity, divergence, shoot_arrow.arrow_critical_strike, null);
                if (weapon instanceof BowItem) {
                    world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
                if (shooter instanceof SpellCasterEntity) {
                    SpellCasterEntity caster = (SpellCasterEntity)shooter;
                    caster.setArrowShootContext(ArrowShootContext.EMPTY);
                }
                int extra_launch = mutableLaunchProperties.extra_launch_count;
                if (sequenceIndex == 0 && extra_launch > 0) {
                    for (int i = 0; i < extra_launch; ++i) {
                        int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                        int nextSequenceIndex = i + 1;
                        ((WorldScheduler)world).schedule(ticks, () -> {
                            if (shooter == null || !shooter.isAlive()) {
                                return;
                            }
                            ArrowHelper.shootArrow(world, shooter, spellEntry, context, nextSequenceIndex);
                        });
                    }
                }
            }
        }
    }

    public static void onArrowShot(ArrowExtension arrow, LivingEntity shooter, Holder<Spell> spellEntry, Supplier<Collection<ServerPlayer>> trackers) {
        if (((Spell)spellEntry.value()).arrow_perks != null) {
            Spell.ArrowPerks arrowPerks = ((Spell)spellEntry.value()).arrow_perks;
            Level world = shooter.level();
            arrow.applyArrowPerks(spellEntry);
            ParticleHelper.sendBatches((Entity)shooter, arrowPerks.launch_particles, 1.0f, trackers.get());
            SoundHelper.playSound(world, (Entity)shooter, arrowPerks.launch_sound);
        }
    }
}

