/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.casting;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public interface SpellBatcher {
    public Map<ResourceLocation, Batch> getSpellBatches();

    default public int getBatchTriggerCount(ResourceLocation id) {
        Batch batch = this.getSpellBatches().get(id);
        return batch != null ? batch.trigger_count : 0;
    }

    default public void batchTriggerCount(ResourceLocation id, int count) {
        Batch batch = this.getSpellBatches().getOrDefault(id, new Batch());
        batch.trigger_count = count;
        this.getSpellBatches().put(id, batch);
    }

    default public void batchTriggerChance(ResourceLocation id, float chance) {
        Batch batch = this.getSpellBatches().getOrDefault(id, new Batch());
        batch.trigger_chance = Float.valueOf(chance);
        this.getSpellBatches().put(id, batch);
    }

    default public Float getBatchTriggerChance(ResourceLocation id) {
        Batch batch = this.getSpellBatches().get(id);
        return batch != null ? batch.trigger_chance : null;
    }

    default public void batchCost(ResourceLocation id, boolean cost) {
        Batch batch = this.getSpellBatches().getOrDefault(id, new Batch());
        batch.cost = cost;
        this.getSpellBatches().put(id, batch);
    }

    default public boolean hasBatchedCost(ResourceLocation id) {
        Batch batch = this.getSpellBatches().get(id);
        return batch != null && batch.cost != null && batch.cost == true;
    }

    public static class Batch {
        public int trigger_count = 0;
        public Float trigger_chance = null;
        public Boolean cost = null;
    }
}

