/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.arrow;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellTriggers;
import net.spell_engine.internals.arrow.ArrowExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class PersistentProjectileEntityMixin
implements ArrowExtension {
    @Shadow
    protected boolean inGround;
    private final List<ResourceLocation> spellIds = new ArrayList<ResourceLocation>();
    private List<Holder<Spell>> cachedSpellEntry = List.of();
    private static final Gson gson = new Gson();
    private static final Type stringListType = new TypeToken<ArrayList<String>>(){}.getType();
    private static final String NBT_KEY_SPELL_ID = "spell_id";
    private static final EntityDataAccessor<String> SPELL_ID_TRACKER = SynchedEntityData.defineId(AbstractArrow.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    @Shadow
    public abstract byte getPierceLevel();

    @Shadow
    public abstract void setPierceLevel(byte var1);

    @Shadow
    public abstract void setBaseDamage(double var1);

    @Shadow
    public abstract double getBaseDamage();

    private AbstractArrow arrow() {
        return (AbstractArrow)this;
    }

    private void addSpellId(ResourceLocation id) {
        if (!this.spellIds.contains(id)) {
            this.spellIds.add(id);
        }
        List<String> stringList = this.spellIds.stream().map(ResourceLocation::toString).toList();
        String json = gson.toJson(stringList);
        this.arrow().getEntityData().set(SPELL_ID_TRACKER, (Object)json);
    }

    @Nullable
    List<Holder<Spell>> spellEntries() {
        if (this.cachedSpellEntry == null || this.cachedSpellEntry.size() != this.spellIds.size()) {
            List<Holder> entries = this.spellIds.stream().map(id -> {
                Holder.Reference reference = SpellRegistry.from(this.arrow().level()).getHolder(id).orElse(null);
                return reference;
            }).toList();
            this.cachedSpellEntry = entries;
        }
        return this.cachedSpellEntry;
    }

    private boolean arrowPerksAlreadyApplied(Holder<Spell> spell) {
        String id = ((ResourceKey)spell.unwrapKey().get()).location().toString();
        return this.spellIds.contains(id);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt_TAIL_SpellEngine(CompoundTag nbt, CallbackInfo ci) {
        List<String> stringList = this.spellIds.stream().map(ResourceLocation::toString).toList();
        String json = gson.toJson(stringList);
        nbt.putString(NBT_KEY_SPELL_ID, json);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt_TAIL_SpellEngine(CompoundTag nbt, CallbackInfo ci) {
        String string;
        if (nbt.contains(NBT_KEY_SPELL_ID) && (string = nbt.getString(NBT_KEY_SPELL_ID)) != null && !string.isEmpty()) {
            List stringList = (List)new Gson().fromJson(string, stringListType);
            this.spellIds.clear();
            for (String idString : stringList) {
                ResourceLocation id = ResourceLocation.tryParse((String)idString);
                if (id == null) continue;
                this.addSpellId(ResourceLocation.parse((String)idString));
            }
        }
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(SPELL_ID_TRACKER, (Object)"");
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick_HEAD_SpellEngine(CallbackInfo ci) {
        AbstractArrow arrow = this.arrow();
        Level world = arrow.level();
        if (world.isClientSide && this.spellIds.isEmpty()) {
            String json = (String)this.arrow().getEntityData().get(SPELL_ID_TRACKER);
            if (json.isEmpty()) {
                return;
            }
            try {
                List stringList = (List)new Gson().fromJson(json, stringListType);
                this.spellIds.clear();
                this.spellIds.addAll(stringList.stream().map(ResourceLocation::parse).toList());
                this.spellEntries();
            }
            catch (Exception e) {
                System.err.println("Spell Engine: Failed to parse spell id from arrow data tracker: " + json);
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine(CallbackInfo ci) {
        for (Holder<Spell> spellEntry : this.spellEntries()) {
            Spell spell = (Spell)spellEntry.value();
            Spell.ArrowPerks perks = spell.arrow_perks;
            if (perks == null || perks.travel_particles == null) continue;
            AbstractArrow arrow = this.arrow();
            for (ParticleBatch travel_particles : perks.travel_particles) {
                ParticleHelper.play(arrow.level(), (Entity)arrow, arrow.getYRot(), arrow.getXRot(), travel_particles);
            }
        }
    }

    @Override
    public boolean isInGround_SpellEngine() {
        return this.inGround;
    }

    @Override
    @Nullable
    public List<Holder<Spell>> getCarriedSpells() {
        return this.spellEntries();
    }

    @Override
    public void applyArrowPerks(Holder<Spell> spellEntry) {
        if (this.arrowPerksAlreadyApplied(spellEntry)) {
            return;
        }
        AbstractArrow arrow = this.arrow();
        Spell.ArrowPerks perks = ((Spell)spellEntry.value()).arrow_perks;
        if (perks != null) {
            if (perks.velocity_multiplier != 1.0f) {
                arrow.setDeltaMovement(arrow.getDeltaMovement().scale((double)perks.velocity_multiplier));
            }
            if (perks.pierce > 0) {
                byte newPierce = (byte)(this.getPierceLevel() + perks.pierce);
                this.setPierceLevel(newPierce);
            }
            this.setBaseDamage(this.getBaseDamage() * (double)perks.damage_multiplier);
        }
        ResourceLocation spellId = ((ResourceKey)spellEntry.unwrapKey().get()).location();
        this.addSpellId(spellId);
    }

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")}, cancellable=true)
    private void onEntityHit_BeforeDamage_SpellEngine(EntityHitResult entityHitResult, CallbackInfo ci) {
        for (Holder<Spell> spellEntry : this.spellEntries()) {
            Spell spell = (Spell)spellEntry.value();
            Spell.ArrowPerks arrowPerks = spell.arrow_perks;
            if (arrowPerks == null || !arrowPerks.skip_arrow_damage) continue;
            ci.cancel();
            this.arrow().discard();
            Entity entity = entityHitResult.getEntity();
            if (entity == null) continue;
            this.performImpacts(spellEntry, entity, entityHitResult);
        }
    }

    @WrapOperation(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean wrapDamageEntity(Entity entity, DamageSource damageSource, float amount, Operation<Boolean> original, EntityHitResult entityHitResult) {
        List<Holder<Spell>> spellEntries = this.spellEntries();
        AbstractArrow arrow = this.arrow();
        Entity owner = arrow.getOwner();
        if (entity.level().isClientSide() || spellEntries.isEmpty()) {
            Boolean result = (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(amount)});
            if (owner instanceof Player) {
                Player shooter = (Player)owner;
                SpellTriggers.onArrowImpact((ArrowExtension)arrow, shooter, entity, damageSource, amount);
            }
            return result;
        }
        int iFrameToRestore = 0;
        int originalIFrame = entity.invulnerableTime;
        float knockbackMultiplier = 1.0f;
        for (Holder<Spell> spellEnrty : spellEntries) {
            Spell spell = (Spell)spellEnrty.value();
            Spell.ArrowPerks arrowPerks = spell.arrow_perks;
            if (arrowPerks == null) continue;
            if (arrowPerks.knockback != 1.0f) {
                knockbackMultiplier *= arrowPerks.knockback;
            }
            if (arrowPerks.bypass_iframes) {
                if (entity.invulnerableTime == originalIFrame) {
                    iFrameToRestore = entity.invulnerableTime;
                }
                entity.invulnerableTime = 0;
            }
            if (arrowPerks.iframe_to_set <= 0) continue;
            iFrameToRestore = arrowPerks.iframe_to_set;
        }
        boolean pushedKnockback = false;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (knockbackMultiplier != 1.0f) {
                ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(knockbackMultiplier);
                pushedKnockback = true;
            }
        }
        Boolean result = (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(amount)});
        for (Holder holder : spellEntries) {
            this.performImpacts((Holder<Spell>)holder, entity, entityHitResult);
        }
        if (owner instanceof Player) {
            Player shooter = (Player)owner;
            SpellTriggers.onArrowImpact((ArrowExtension)arrow, shooter, entity, damageSource, amount);
        }
        if (pushedKnockback) {
            ((ConfigurableKnockback)entity).popKnockbackMultiplier_SpellEngine();
        }
        if (iFrameToRestore != 0) {
            entity.invulnerableTime = iFrameToRestore;
        }
        return result;
    }

    private void performImpacts(Holder<Spell> spellEntry, Entity target, EntityHitResult entityHitResult) {
        AbstractArrow arrow = this.arrow();
        Entity owner = arrow.getOwner();
        if (spellEntry != null && ((Spell)spellEntry.value()).impacts != null && owner instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)owner;
            SpellHelper.arrowImpact(shooter, (Entity)arrow, target, spellEntry, new SpellHelper.ImpactContext().position(entityHitResult.getLocation()));
        }
    }
}

