/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client;

import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.PlatformClient;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
implements SpellCasterClient {
    @Shadow
    @Final
    public ClientPacketListener connection;
    private SpellTarget.SearchResult spellTarget = SpellTarget.SearchResult.empty();
    @Nullable
    private SpellCast.Process spellCastProcess;

    private LocalPlayer player() {
        return (LocalPlayer)this;
    }

    private Entity firstTarget() {
        return this.spellTarget.entities().stream().findFirst().orElse(null);
    }

    @Override
    @Nullable
    public SpellCast.Process getSpellCastProcess() {
        return this.spellCastProcess;
    }

    @Override
    public Spell getCurrentSpell() {
        if (this.spellCastProcess != null) {
            return (Spell)this.spellCastProcess.spell().value();
        }
        return null;
    }

    @Override
    public float getCurrentCastingSpeed() {
        if (this.spellCastProcess != null) {
            return this.spellCastProcess.speed();
        }
        return 1.0f;
    }

    @Override
    public boolean isCastingSpell() {
        return this.spellCastProcess != null;
    }

    private void setSpellCastProcess(SpellCast.Process newValue, boolean sync) {
        SpellCast.Process oldValue = this.spellCastProcess;
        this.spellCastProcess = newValue;
        if (sync && !Objects.equals(oldValue, newValue)) {
            ResourceLocation id = null;
            float speed = 0.0f;
            int length = 0;
            if (newValue != null) {
                id = ((ResourceKey)newValue.spell().unwrapKey().get()).location();
                speed = newValue.speed();
                length = newValue.length();
            }
            ClientPlayNetworking.send((CustomPacketPayload)new Packets.SpellCastSync(id, speed, length));
        }
    }

    @Override
    public SpellCast.Attempt startSpellCast(ItemStack itemStack, Holder<Spell> spellEntry) {
        LocalPlayer caster = this.player();
        if (caster.isSpectator()) {
            return SpellCast.Attempt.none();
        }
        if (spellEntry == null) {
            this.cancelSpellCast();
            return SpellCast.Attempt.none();
        }
        Spell spell = (Spell)spellEntry.value();
        ResourceLocation spellId = ((ResourceKey)spellEntry.unwrapKey().get()).location();
        if (this.spellCastProcess != null && this.spellCastProcess.id().equals((Object)spellId) || spell == null) {
            return SpellCast.Attempt.none();
        }
        if (EntityActionsAllowed.isImpaired((LivingEntity)caster, EntityActionsAllowed.Player.CAST_SPELL, true)) {
            return SpellCast.Attempt.none();
        }
        SpellCast.Attempt attempt = SpellHelper.attemptCasting((Player)caster, itemStack, spellId);
        if (attempt.isSuccess()) {
            boolean instant;
            if (this.spellCastProcess != null) {
                this.cancelSpellCast(false);
            }
            if (instant = SpellHelper.isInstantCast(spellEntry, (LivingEntity)caster)) {
                SpellCast.Process process = new SpellCast.Process(spellEntry, itemStack.getItem(), 1.0f, 0, caster.level().getGameTime());
                this.setSpellCastProcess(process, false);
                this.updateSpellCast();
                this.applyInstantGlobalCooldown();
            } else {
                SpellCast.Duration details = SpellHelper.getCastTimeDetails((LivingEntity)caster, spell);
                this.setSpellCastProcess(new SpellCast.Process(spellEntry, itemStack.getItem(), details.speed(), details.length(), caster.level().getGameTime()), true);
            }
        }
        return attempt;
    }

    private void applyInstantGlobalCooldown() {
        int duration = SpellEngineMod.config.spell_instant_cast_gcd;
        if (duration > 0) {
            for (SpellHotbar.Slot slot : SpellHotbar.INSTANCE.slots) {
                Holder<Spell> spellEntry = slot.spell();
                Spell spell = (Spell)spellEntry.value();
                if (spell.active == null || spell.active.cast == null || !(spell.active.cast.duration <= 0.0f)) continue;
                this.getCooldownManager().set(((ResourceKey)spellEntry.unwrapKey().get()).location(), duration, false);
            }
        }
    }

    @Override
    @Nullable
    public SpellCast.Progress getSpellCastProgress() {
        if (this.spellCastProcess != null) {
            LocalPlayer player = this.player();
            return this.spellCastProcess.progress(player.level().getGameTime());
        }
        return null;
    }

    @Override
    public void cancelSpellCast() {
        this.cancelSpellCast(true);
    }

    public void cancelSpellCast(boolean syncProcess) {
        SpellCast.Process process = this.spellCastProcess;
        if (process != null && SpellHelper.isChanneled((Spell)process.spell().value())) {
            LocalPlayer player = this.player();
            SpellCast.Progress progress = process.progress(player.level().getGameTime());
            ClientPlayNetworking.send((CustomPacketPayload)new Packets.SpellRequest(SpellCast.Action.RELEASE, process.id(), progress.ratio(), new int[0], null));
        }
        this.setSpellCastProcess(null, syncProcess);
        this.spellTarget = SpellTarget.SearchResult.empty();
    }

    private void updateSpellCast() {
        SpellCast.Process process = this.spellCastProcess;
        if (process != null) {
            LocalPlayer player = this.player();
            if (!this.player().isAlive() || player.getMainHandItem().getItem() != process.item() || this.getCooldownManager().isCoolingDown(process.id()) || EntityActionsAllowed.isImpaired((LivingEntity)player, EntityActionsAllowed.Player.CAST_SPELL, true)) {
                this.cancelSpellCast();
                return;
            }
            Spell spell = (Spell)process.spell().value();
            Spell.Active.Cast cast = spell.active.cast;
            this.spellTarget = SpellTarget.findTargets((Player)player, process.spell(), this.spellTarget, SpellEngineClient.config.filterInvalidTargets);
            int spellCastTicks = process.spellCastTicksSoFar(player.level().getGameTime());
            if (SpellHelper.isChanneled(spell)) {
                boolean isDue;
                int offset = Math.round((float)cast.channel_ticks * 0.5f);
                int currentTick = spellCastTicks + offset;
                boolean bl = isDue = currentTick >= cast.channel_ticks && currentTick % cast.channel_ticks == 0;
                if (isDue) {
                    this.releaseSpellCast(process, SpellCast.Action.CHANNEL);
                }
            } else {
                boolean isFinished;
                boolean bl = isFinished = spellCastTicks >= process.length();
                if (isFinished) {
                    this.releaseSpellCast(process, SpellCast.Action.RELEASE);
                }
            }
        } else {
            this.spellTarget = SpellTarget.SearchResult.empty();
        }
    }

    private void releaseSpellCast(SpellCast.Process process, SpellCast.Action action) {
        ResourceLocation spellId = process.id();
        Spell spell = (Spell)process.spell().value();
        LocalPlayer player = this.player();
        SpellCast.Progress progress = process.progress(player.level().getGameTime());
        List<Entity> targets = this.spellTarget.entities();
        Vec3 location = this.spellTarget.location();
        int[] targetIDs = new int[targets.size()];
        int i = 0;
        for (Entity target : targets) {
            targetIDs[i] = target.getId();
            ++i;
        }
        ClientPlayNetworking.send((CustomPacketPayload)new Packets.SpellRequest(action, spellId, progress.ratio(), targetIDs, location));
        switch (action) {
            case CHANNEL: {
                if (!(progress.ratio() >= 1.0f)) break;
                this.cancelSpellCast();
                break;
            }
            case RELEASE: {
                this.cancelSpellCast();
            }
        }
    }

    @Override
    public List<Entity> getCurrentTargets() {
        List<Entity> targets = this.spellTarget.entities();
        if (targets == null) {
            return List.of();
        }
        return targets;
    }

    @Override
    public Entity getCurrentFirstTarget() {
        return this.firstTarget();
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine(CallbackInfo ci) {
        this.updateSpellCast();
        LocalPlayer player = this.player();
        if (this.isBeaming()) {
            PlatformClient.util().sendVanillaPacket_C2S(player, (Packet<?>)new ServerboundMovePlayerPacket.PosRot(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot(), player.onGround()));
        }
    }
}

