/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.entity;

import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityCollision
implements TwoWayCollisionChecker {
    private Function<Entity, TwoWayCollisionChecker.CollisionResult> reverseCollisionChecker;

    @Override
    @Nullable
    public Function<Entity, TwoWayCollisionChecker.CollisionResult> getReverseCollisionChecker() {
        return this.reverseCollisionChecker;
    }

    @Override
    public void setReverseCollisionChecker(Function<Entity, TwoWayCollisionChecker.CollisionResult> reverseCollisionChecker) {
        this.reverseCollisionChecker = reverseCollisionChecker;
    }

    @Inject(method={"canCollideWith(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCollidesWith(Entity other, CallbackInfoReturnable<Boolean> cir) {
        Function<Entity, TwoWayCollisionChecker.CollisionResult> reverse = ((TwoWayCollisionChecker)other).getReverseCollisionChecker();
        if (reverse != null && this.reverseCollisionChecker == null) {
            TwoWayCollisionChecker.CollisionResult result = reverse.apply((Entity)this);
            switch (result) {
                case COLLIDE: {
                    cir.setReturnValue((Object)true);
                    cir.cancel();
                    break;
                }
                case PASS: {
                    cir.setReturnValue((Object)false);
                    cir.cancel();
                }
            }
        }
    }
}

