/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.spell.Spell;

public class InstantCast {
    private static Map<ResourceKey<MobEffect>, Args> instantCastEffects = new HashMap<ResourceKey<MobEffect>, Args>();

    public static void register(Holder<MobEffect> effect, ResourceKey<Spell> spell) {
        InstantCast.register((ResourceKey<MobEffect>)((ResourceKey)effect.unwrapKey().get()), Args.spell(spell));
    }

    public static void register(Holder<MobEffect> effect, TagKey<Spell> tag) {
        InstantCast.register((ResourceKey<MobEffect>)((ResourceKey)effect.unwrapKey().get()), Args.tag(tag));
    }

    public static void register(ResourceKey<MobEffect> effect, Args args) {
        instantCastEffects.put(effect, args);
    }

    public static boolean instantify(Holder<Spell> spellEntry, LivingEntity caster) {
        for (Map.Entry entry : caster.getActiveEffectsMap().entrySet()) {
            Args args;
            Optional effectKey = ((MobEffectInstance)entry.getValue()).getEffect().unwrapKey();
            if (effectKey.isEmpty() || (args = instantCastEffects.get(effectKey.get())) == null) continue;
            switch (args.selection.ordinal()) {
                case 0: {
                    return true;
                }
                case 1: {
                    if (!args.spell.equals(spellEntry.unwrapKey().get())) break;
                    return true;
                }
                case 2: {
                    if (!spellEntry.is(args.tag)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public record Args(Selection selection, ResourceKey<Spell> spell, TagKey<Spell> tag) {
        public static Args spell(ResourceKey<Spell> spell) {
            return new Args(Selection.SINGLE, spell, null);
        }

        public static Args tag(TagKey<Spell> tag) {
            return new Args(Selection.TAG, null, tag);
        }
    }

    public static enum Selection {
        NONE,
        SINGLE,
        TAG;

    }
}

