/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.entity;

import java.util.Collection;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.tags.SpellEngineDamageTypeTags;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.VectorHelper;

public class EvasionLogic {
    private static final Random RNG = new Random();
    private static final Sound evadeSound = new Sound("spell_engine:dodge", 1.0f, 1.0f, 0.1f);

    public static boolean tryEvade(LivingEntity entity, float damage, DamageSource source) {
        SpellCasterEntity casterEntity;
        if (entity.isSleeping()) {
            return false;
        }
        ServerConfig config = SpellEngineMod.config;
        if (!config.attribute_evasion_allowed_while_spell_casting && entity instanceof SpellCasterEntity && (casterEntity = (SpellCasterEntity)entity).isCastingSpell()) {
            return false;
        }
        if (!config.attribute_evasion_allowed_while_item_usage && entity.isUsingItem()) {
            return false;
        }
        if (source.is(SpellEngineDamageTypeTags.EVADABLE)) {
            float chance = (float)SpellEngineAttributes.EVASION_CHANCE.asChance(entity.getAttributeValue(SpellEngineAttributes.EVASION_CHANCE.entry));
            float angleOfAttack = 0.0f;
            float evasionAngleLimit = config.attribute_evasion_angle;
            if (evasionAngleLimit > 0.0f && source.getDirectEntity() != null) {
                Vec3 sourcePos = source.getSourcePosition() != null ? source.getSourcePosition() : source.getDirectEntity().position();
                angleOfAttack = (float)VectorHelper.angleBetween(entity.getViewVector(1.0f), new Vec3(sourcePos.x() - entity.getX(), 0.0, sourcePos.z() - entity.getZ()));
                angleOfAttack = Math.abs(angleOfAttack);
            }
            return chance > 0.0f && RNG.nextFloat() < chance && angleOfAttack <= evasionAngleLimit;
        }
        return false;
    }

    public static void onEvade(LivingEntity entity, float damage, DamageSource source) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Collection tracker = PlayerLookup.tracking((Entity)player);
            AnimationHelper.sendAnimation((Player)player, tracker, SpellCast.Animation.MISC, "spell_engine:dodge", 1.0f);
        }
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SpellEngineSounds.DODGE.soundEvent(), entity.getSoundSource(), 1.0f, evadeSound.randomizedPitch());
        CombatEvents.ENTITY_EVASION.invoke(listener -> listener.onEntityEvasion(new CombatEvents.EntityEvasion.Args(entity, damage, source)));
    }

    public static interface Evader {
        public DamageSource getLastEvaded();

        public void setLastEvaded(DamageSource var1);
    }
}

