/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.render.LightEmission;

public class CustomLayers
extends RenderType {
    BiFunction<ResourceLocation, Boolean, RenderType> BEACON_BEAM = Util.memoize((texture, affectsOutline) -> {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_BEACON_BEAM_SHADER).setCullState(NO_CULL).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(affectsOutline != false ? TRANSLUCENT_TRANSPARENCY : NO_TRANSPARENCY).setWriteMaskState(affectsOutline != false ? COLOR_WRITE : COLOR_DEPTH_WRITE).createCompositeState(false);
        return CustomLayers.create((String)"beacon_beam", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    });
    protected static final RenderStateShard.TransparencyStateShard BEAM_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("beam_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    public CustomLayers(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static RenderType beam(ResourceLocation texture, boolean cull, boolean transparent) {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.builder().setShaderState(RENDERTYPE_BEACON_BEAM_SHADER).setCullState(cull ? CULL : NO_CULL).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(transparent ? BEAM_TRANSPARENCY : NO_TRANSPARENCY).setWriteMaskState(transparent ? COLOR_DEPTH_WRITE : COLOR_DEPTH_WRITE).createCompositeState(false);
        return RenderType.create((String)"spell_beam", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType spellEffect(LightEmission lightEmission, boolean translucent) {
        return CustomLayers.spellObject(TextureAtlas.LOCATION_BLOCKS, lightEmission, translucent);
    }

    public static RenderType projectile(LightEmission lightEmission) {
        return CustomLayers.spellObject(TextureAtlas.LOCATION_BLOCKS, lightEmission, false);
    }

    public static RenderType create(ResourceLocation texture, RenderStateShard.ShaderStateShard shaderProgram, RenderStateShard.TransparencyStateShard transparency, RenderStateShard.CullStateShard culling, RenderStateShard.WriteMaskStateShard writeMask, RenderStateShard.OverlayStateShard overlay, RenderStateShard.OutputStateShard target, boolean affectsOutline) {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.builder().setShaderState(shaderProgram).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(transparency).setCullState(culling).setWriteMaskState(writeMask).setOverlayState(overlay).setOutputState(target).createCompositeState(affectsOutline);
        return RenderType.create((String)"entity_translucent_emissive", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType spellObject(LightEmission lightEmission) {
        switch (lightEmission) {
            case RADIATE: {
                return CustomLayers.spellObject(TextureAtlas.LOCATION_BLOCKS, lightEmission, false);
            }
            case GLOW: {
                return CustomLayers.spellObject(TextureAtlas.LOCATION_BLOCKS, lightEmission, false);
            }
        }
        return RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
    }

    public static RenderType spellObject(ResourceLocation texture, LightEmission lightEmission, boolean translucent) {
        RenderStateShard.ShaderStateShard shaderProgram = switch (lightEmission) {
            default -> throw new MatchException(null, null);
            case LightEmission.RADIATE -> RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER;
            case LightEmission.GLOW -> RENDERTYPE_BEACON_BEAM_SHADER;
            case LightEmission.NONE -> RENDERTYPE_ENTITY_TRANSLUCENT_SHADER;
        };
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.builder().setShaderState(shaderProgram).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setTransparencyState(translucent ? TRANSLUCENT_TRANSPARENCY : NO_TRANSPARENCY).setCullState(NO_CULL).setWriteMaskState(translucent ? COLOR_WRITE : COLOR_DEPTH_WRITE).setOverlayState(OVERLAY).setOutputState(PARTICLES_TARGET).createCompositeState(false);
        return RenderType.create((String)"entity_translucent_emissive", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType create(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, RenderType.CompositeState phases) {
        return RenderType.create((String)name, (VertexFormat)vertexFormat, (VertexFormat.Mode)drawMode, (int)expectedBufferSize, (boolean)hasCrumbling, (boolean)translucent, (RenderType.CompositeState)phases);
    }
}

