/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell.container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record SpellContainer(ContentType content, boolean is_proxy, String pool, String slot, int max_spell_count, List<String> spell_ids) {
    public static final Codec<SpellContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContentType.CODEC.optionalFieldOf("content", (Object)ContentType.MAGIC).forGetter(x -> x.content), (App)Codec.BOOL.optionalFieldOf("is_proxy", (Object)false).forGetter(x -> x.is_proxy), (App)Codec.STRING.optionalFieldOf("pool", (Object)"").forGetter(x -> x.pool), (App)Codec.STRING.optionalFieldOf("slot", (Object)"").forGetter(x -> x.slot), (App)Codec.INT.optionalFieldOf("max_spell_count", (Object)0).forGetter(x -> x.max_spell_count), (App)Codec.STRING.listOf().optionalFieldOf("spell_ids", List.of()).forGetter(x -> x.spell_ids)).apply((Applicative)instance, SpellContainer::new));
    public static final SpellContainer EMPTY = new SpellContainer(ContentType.MAGIC, false, "", 0, List.of());

    public SpellContainer(ContentType content, boolean is_proxy, String pool, int max_spell_count, List<String> spell_ids) {
        this(content, is_proxy, pool, "", max_spell_count, spell_ids);
    }

    public SpellContainer(ContentType content, boolean is_proxy, String pool, String slot, int max_spell_count, List<String> spell_ids) {
        this.content = content != null ? content : ContentType.MAGIC;
        this.is_proxy = is_proxy;
        this.pool = pool != null ? pool : "";
        this.slot = slot != null ? slot : "";
        this.max_spell_count = max_spell_count;
        this.spell_ids = spell_ids != null ? spell_ids : List.of();
    }

    public boolean isValid() {
        if (this.is_proxy) {
            return true;
        }
        if (this.max_spell_count < 0) {
            return false;
        }
        return !this.spell_ids.isEmpty() || this.pool != null && !this.pool.isEmpty();
    }

    public boolean contains(ResourceLocation spellId) {
        return this.spell_ids.contains(spellId.toString());
    }

    public boolean contentMatches(@Nullable ContentType other) {
        return other == null || this.content() == ContentType.ANY || this.content() == other;
    }

    public boolean slotMatches(@Nullable String other) {
        return other == null || this.slot().contains(other);
    }

    public boolean isUsable() {
        return this.isValid() && !this.spell_ids.isEmpty();
    }

    public SpellContainer copy() {
        return new SpellContainer(this.content, this.is_proxy, this.pool, this.max_spell_count, new ArrayList<String>(this.spell_ids));
    }

    public SpellContainer copyWith(List<String> spell_ids) {
        return new SpellContainer(this.content, this.is_proxy, this.pool, this.max_spell_count, spell_ids);
    }

    public SpellContainer withContentType(ContentType content) {
        return new SpellContainer(content, this.is_proxy, this.pool, this.max_spell_count, this.spell_ids);
    }

    public SpellContainer withBindingPool(ResourceLocation poolId) {
        return new SpellContainer(this.content, this.is_proxy, poolId.toString(), this.max_spell_count, this.spell_ids);
    }

    public SpellContainer withMaxSpellCount(int maxSpellCount) {
        return new SpellContainer(this.content, this.is_proxy, this.pool, maxSpellCount, this.spell_ids);
    }

    public SpellContainer withAdditionalSpell(List<String> spellIds) {
        ArrayList<String> newSpellIds = new ArrayList<String>(this.spell_ids);
        newSpellIds.addAll(spellIds);
        return new SpellContainer(this.content, this.is_proxy, this.pool, this.max_spell_count, newSpellIds);
    }

    public static enum ContentType {
        ANY,
        MAGIC,
        ARCHERY;

        public static Codec<ContentType> CODEC;

        static {
            CODEC = Codec.STRING.xmap(ContentType::valueOf, Enum::name);
        }
    }
}

