/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.client.gui.Drawable;

public class CustomButton
extends Button {
    private static final ResourceLocation BUTTONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"textures/gui/buttons.png");
    private int u;
    private int v;
    private int stateOffsetY;

    public CustomButton(int x, int y, Type type, Button.OnPress onPress) {
        super(x, y, type.width(), type.height(), (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.u = type.u();
        this.v = type.v();
        this.stateOffsetY = type.stateOffsetY();
    }

    private int getTextureY() {
        int i = 0;
        if (!this.active) {
            i = 2;
        } else if (this.isHovered()) {
            i = 1;
        }
        return this.v + i * this.stateOffsetY;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.getInstance();
        context.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        context.blit(BUTTONS_TEXTURE, this.getX(), this.getY(), this.u, this.getTextureY(), this.getWidth(), this.getHeight());
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    public static enum Type {
        SMALL_UP,
        SMALL_DOWN;


        private Drawable.DrawRect rect() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new Drawable.DrawRect(0, 0, 11, 7);
                case 1 -> new Drawable.DrawRect(16, 0, 11, 7);
            };
        }

        public int stateOffsetY() {
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 1: 
            }
            return 16;
        }

        public int width() {
            return this.rect().width();
        }

        public int height() {
            return this.rect().height();
        }

        public int u() {
            return this.rect().u();
        }

        public int v() {
            return this.rect().v();
        }
    }
}

