/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudRenderHelper;
import net.spell_engine.config.HudConfig;

public class HudConfigScreen
extends Screen {
    private Screen previous;
    private boolean partConfigVisible = false;
    private final ArrayList<AbstractWidget> partButtons = new ArrayList();
    private final Map<Part, Checkbox> checkBoxes = new HashMap<Part, Checkbox>();
    private Dragged dragged;
    private int lastSelectedPreset = 0;

    public HudConfigScreen(Screen previous) {
        super((Component)Component.translatable((String)"gui.spell_engine.hud"));
        this.previous = previous;
    }

    private HudConfig config() {
        return (HudConfig)SpellEngineClient.hudConfig.value;
    }

    protected void init() {
        int buttonWidth = 60;
        int padding = 5;
        int buttonHeight = 20;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"x"), button -> this.onClose()).pos(5, 5).size(buttonHeight, buttonHeight).build());
        int y = centerY - 50;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.spell_engine.parts"), button -> this.toggleParts()).pos(centerX - padding - buttonWidth - buttonWidth / 2, y).size(buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.spell_engine.preset"), button -> this.nextPreset()).pos(centerX - buttonWidth / 2, y).size(buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.spell_engine.reset"), button -> this.reset()).pos(centerX + padding + buttonWidth - buttonWidth / 2, y).size(buttonWidth, buttonHeight).build());
        this.setupPartButtons();
    }

    private void setupPartButtons() {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int buttonWidth = 60;
        int y = centerY - 20;
        int x = centerX - buttonWidth / 2;
        List<AbstractWidget> targetButtons = this.createPartAdjustmentButtons(Part.TARGET, x, y);
        targetButtons.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.partButtons.addAll(targetButtons);
        List<AbstractWidget> iconButtons = this.createPartAdjustmentButtons(Part.ICON, x, y += 28);
        iconButtons.forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.partButtons.addAll(iconButtons);
        List<Button> sizeButtons = this.createBarSizeButtons(x, y += 28);
        sizeButtons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.partButtons.addAll(sizeButtons);
        this.setPartsVisibility(this.partConfigVisible);
    }

    private List<AbstractWidget> createPartAdjustmentButtons(Part part, int x, int y) {
        ArrayList<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
        int buttonSize = 20;
        int spacing = 8;
        boolean checked = this.partData((Part)part).visible;
        Checkbox checkBox = Checkbox.builder((Component)Component.nullToEmpty((String)""), (Font)this.font).pos(x, y).selected(checked).build();
        buttons.add((AbstractWidget)checkBox);
        this.checkBoxes.put(part, checkBox);
        Button but = Button.builder((Component)Component.nullToEmpty((String)"\u2190"), button -> this.move(part, Direction.LEFT)).pos(x += buttonSize + spacing, y).size(buttonSize, buttonSize).build();
        this.addRenderableWidget((GuiEventListener)but);
        buttons.add((AbstractWidget)but);
        but = Button.builder((Component)Component.nullToEmpty((String)"\u2191"), button -> this.move(part, Direction.UP)).pos(x += buttonSize + spacing, y).size(buttonSize, buttonSize).build();
        this.addRenderableWidget((GuiEventListener)but);
        buttons.add((AbstractWidget)but);
        but = Button.builder((Component)Component.nullToEmpty((String)"\u2193"), button -> this.move(part, Direction.DOWN)).pos(x += buttonSize + spacing, y).size(buttonSize, buttonSize).build();
        this.addRenderableWidget((GuiEventListener)but);
        buttons.add((AbstractWidget)but);
        but = Button.builder((Component)Component.nullToEmpty((String)"\u2192"), button -> this.move(part, Direction.RIGHT)).pos(x += buttonSize + spacing, y).size(buttonSize, buttonSize).build();
        this.addRenderableWidget((GuiEventListener)but);
        buttons.add((AbstractWidget)but);
        return buttons;
    }

    private List<Button> createBarSizeButtons(int x, int y) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        int buttonSize = 20;
        int spacing = 8;
        Button but = Button.builder((Component)Component.nullToEmpty((String)"-"), button -> this.changeBarWidth(false)).pos(x, y).size(buttonSize, buttonSize).build();
        this.addRenderableWidget((GuiEventListener)but);
        buttons.add(but);
        but = Button.builder((Component)Component.nullToEmpty((String)"+"), button -> this.changeBarWidth(true)).pos(x += buttonSize + spacing, y).size(buttonSize, buttonSize).build();
        this.addRenderableWidget((GuiEventListener)but);
        buttons.add(but);
        return buttons;
    }

    private void move(Part partType, Direction direction) {
        HudConfig.Part part = this.partData(partType);
        if (part != null) {
            Vec2 diff = Vec2.ZERO;
            switch (direction.ordinal()) {
                case 0: {
                    diff = new Vec2(-1.0f, 0.0f);
                    break;
                }
                case 1: {
                    diff = new Vec2(1.0f, 0.0f);
                    break;
                }
                case 2: {
                    diff = new Vec2(0.0f, -1.0f);
                    break;
                }
                case 3: {
                    diff = new Vec2(0.0f, 1.0f);
                }
            }
            part.offset = part.offset.add(diff);
        }
    }

    private HudConfig.Part partData(Part partType) {
        switch (partType.ordinal()) {
            case 0: {
                return this.config().castbar.target;
            }
            case 1: {
                return this.config().castbar.icon;
            }
        }
        return null;
    }

    private void changeBarWidth(boolean increase) {
        int diff = increase ? 1 : -1;
        HudConfig config = (HudConfig)SpellEngineClient.hudConfig.value;
        if (!increase && config.castbar.width <= 0) {
            return;
        }
        config.castbar.width += diff;
    }

    private boolean partsVisible() {
        return this.partConfigVisible;
    }

    private void toggleParts() {
        this.setPartsVisibility(!this.partConfigVisible);
    }

    private void setPartsVisibility(boolean visibility) {
        this.partConfigVisible = visibility;
        for (AbstractWidget button : this.partButtons) {
            button.visible = this.partConfigVisible;
        }
    }

    public void onClose() {
        this.save();
        this.minecraft.setScreen(this.previous);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        HudRenderHelper.render(context, delta, true);
        if (this.partsVisible()) {
            int bigButtonWidth = 60;
            int centerX = this.width / 2;
            int centerY = this.height / 2;
            int lineSpacing = 28;
            int x = centerX - bigButtonWidth / 2 - 8;
            int y = centerY - 20 + 6;
            this.rightAlignedText(context, x, y, "gui.spell_engine.target");
            this.rightAlignedText(context, x, y += lineSpacing, "gui.spell_engine.icon");
            this.rightAlignedText(context, x, y += lineSpacing, "gui.spell_engine.bar_width");
        }
        for (Map.Entry<Part, Checkbox> entry : this.checkBoxes.entrySet()) {
            this.partData((Part)entry.getKey()).visible = entry.getValue().selected();
        }
    }

    private void rightAlignedText(GuiGraphics context, int x, int y, String text) {
        String translated = I18n.get((String)text, (Object[])new Object[0]);
        int width = this.font.width(translated);
        context.drawString(this.font, translated, x - width, y, 0xFFFFFF, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (HudRenderHelper.CastBarWidget.lastRendered != null && HudRenderHelper.CastBarWidget.lastRendered.contains(mouseX, mouseY)) {
            this.dragged = Dragged.CAST_BAR;
            return true;
        }
        if (HudRenderHelper.SpellHotBarWidget.lastRendered != null && HudRenderHelper.SpellHotBarWidget.lastRendered.contains(mouseX, mouseY)) {
            this.dragged = Dragged.HOT_BAR;
            return true;
        }
        if (HudRenderHelper.ErrorMessageWidget.lastRendered != null && HudRenderHelper.ErrorMessageWidget.lastRendered.contains(mouseX, mouseY)) {
            this.dragged = Dragged.ERROR_MESSAGE;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragged = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean result = super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        if (!this.isDragging() && button == 0 && this.dragged != null) {
            HudConfig config = (HudConfig)SpellEngineClient.hudConfig.value;
            switch (this.dragged.ordinal()) {
                case 0: {
                    config.castbar.base.offset = new Vec2((float)((double)config.castbar.base.offset.x + deltaX), (float)((double)config.castbar.base.offset.y + deltaY));
                    break;
                }
                case 1: {
                    config.hotbar.offset = new Vec2((float)((double)config.hotbar.offset.x + deltaX), (float)((double)config.hotbar.offset.y + deltaY));
                    break;
                }
                case 2: {
                    config.error_message.offset = new Vec2((float)((double)config.error_message.offset.x + deltaX), (float)((double)config.error_message.offset.y + deltaY));
                }
            }
        }
        return result;
    }

    public void nextPreset() {
        ++this.lastSelectedPreset;
        try {
            SpellEngineClient.hudConfig.value = HudConfig.presets.get(this.lastSelectedPreset).copy();
        }
        catch (Exception e) {
            this.lastSelectedPreset = 0;
            SpellEngineClient.hudConfig.value = HudConfig.presets.get(0).copy();
        }
        this.refreshPartButtons();
    }

    public void save() {
        SpellEngineClient.hudConfig.save();
    }

    public void reset() {
        SpellEngineClient.hudConfig.value = HudConfig.createDefault();
        this.refreshPartButtons();
    }

    private void refreshPartButtons() {
        for (AbstractWidget partButton : this.partButtons) {
            this.removeWidget((GuiEventListener)partButton);
        }
        this.partButtons.clear();
        this.setupPartButtons();
    }

    static enum Part {
        TARGET,
        ICON;

    }

    static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }

    private static enum Dragged {
        CAST_BAR,
        HOT_BAR,
        ERROR_MESSAGE;

    }
}

