/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.accessories;

import io.wispforest.accessories.api.AccessoryItem;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpellHostAccessoryItem
extends AccessoryItem {
    private final Supplier<Holder<SoundEvent>> equipSound;

    public SpellHostAccessoryItem(Item.Properties settings, Supplier<Holder<SoundEvent>> equipSound) {
        super(settings);
        this.equipSound = equipSound;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public boolean canUnequip(ItemStack stack, SlotReference reference) {
        boolean isOnCooldown = false;
        LivingEntity entity = reference.entity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            isOnCooldown = !player.isCreative() && player.getCooldowns().isOnCooldown(stack.getItem());
        }
        return super.canUnequip(stack, reference) && !isOnCooldown;
    }

    public SoundEventData getEquipSound(ItemStack stack, SlotReference reference) {
        Holder<SoundEvent> entry = this.equipSound.get();
        if (entry != null) {
            return new SoundEventData(entry, 1.0f, 1.0f);
        }
        return null;
    }
}

