/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.utils.WorldScheduler;

public class StatusEffectUtil {
    public static void applyChanges(LivingEntity livingEntity, List<Diff> changes) {
        for (Diff change : changes) {
            int newAmplifier = change.newAmplifier;
            if (change.delay > 0) {
                Holder effectType = change.effect.getEffect();
                ((WorldScheduler)livingEntity.level()).schedule(change.delay - 1, () -> {
                    MobEffectInstance effect = livingEntity.getEffect(effectType);
                    if (effect == null) {
                        return;
                    }
                    StatusEffectUtil.processRemoval(livingEntity, effect, newAmplifier);
                });
                continue;
            }
            StatusEffectUtil.processRemoval(livingEntity, change.effect, newAmplifier);
        }
    }

    private static void processRemoval(LivingEntity livingEntity, MobEffectInstance effect, int newAmplifier) {
        if (newAmplifier < 0) {
            livingEntity.removeEffect(effect.getEffect());
        } else {
            MobEffectInstance current = effect;
            MobEffectInstance newInstance = StatusEffectUtil.copyWithNewAmplifier(current, newAmplifier);
            livingEntity.removeEffect(effect.getEffect());
            livingEntity.addEffect(newInstance);
        }
    }

    public static MobEffectInstance copyWithNewAmplifier(MobEffectInstance instance, int newAmplifier) {
        return new MobEffectInstance(instance.getEffect(), instance.getDuration(), newAmplifier, instance.isAmbient(), instance.isVisible(), instance.showIcon());
    }

    public record Diff(MobEffectInstance effect, int newAmplifier, int delay) {
        public Diff(MobEffectInstance effect, int newAmplifier) {
            this(effect, newAmplifier, 0);
        }
    }
}

