/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.config;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConditionalAttributes;

public class ArmorSetConfig {
    public float armor_toughness = 0.0f;
    public float knockback_resistance = 0.0f;
    public Piece head = new Piece();
    public Piece chest = new Piece();
    public Piece legs = new Piece();
    public Piece feet = new Piece();

    public static ArmorSetConfig with(Piece head, Piece chest, Piece legs, Piece feet) {
        ArmorSetConfig set = new ArmorSetConfig();
        set.head = head;
        set.chest = chest;
        set.legs = legs;
        set.feet = feet;
        return set;
    }

    public static class Piece {
        public int armor = 0;
        public ArrayList<AttributeModifier> attributes = new ArrayList();
        public ConditionalAttributes conditional_attributes = null;

        public Piece() {
        }

        public Piece(int armor) {
            this.armor = armor;
        }

        public List<AttributeModifier> selectedAttributes() {
            if (this.conditional_attributes != null && this.conditional_attributes.required_mod() != null && FabricLoader.getInstance().isModLoaded(this.conditional_attributes.required_mod())) {
                return this.conditional_attributes.attributes();
            }
            return this.attributes;
        }

        public Piece add(AttributeModifier attribute) {
            this.attributes.add(attribute);
            return this;
        }

        public Piece addAll(List<AttributeModifier> attributes) {
            this.attributes.addAll(attributes);
            return this;
        }

        public Piece addConditional(String required_mod, List<AttributeModifier> attributes) {
            this.conditional_attributes = new ConditionalAttributes(required_mod, attributes);
            return this;
        }
    }
}

