/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.entity;

import java.util.Collection;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.tags.SpellEngineDamageTypeTags;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.VectorHelper;

public class EvasionLogic {
    private static final Random RNG = new Random();
    private static final Sound evadeSound = new Sound("spell_engine:dodge", 1.0f, 1.0f, 0.1f);

    public static boolean tryEvade(class_1309 entity, float damage, class_1282 source) {
        SpellCasterEntity casterEntity;
        if (entity.method_6113()) {
            return false;
        }
        ServerConfig config = SpellEngineMod.config;
        if (!config.attribute_evasion_allowed_while_spell_casting && entity instanceof SpellCasterEntity && (casterEntity = (SpellCasterEntity)entity).isCastingSpell()) {
            return false;
        }
        if (!config.attribute_evasion_allowed_while_item_usage && entity.method_6115()) {
            return false;
        }
        if (source.method_48789(SpellEngineDamageTypeTags.EVADABLE)) {
            float chance = (float)SpellEngineAttributes.EVASION_CHANCE.asChance(entity.method_45325(SpellEngineAttributes.EVASION_CHANCE.entry));
            float angleOfAttack = 0.0f;
            float evasionAngleLimit = config.attribute_evasion_angle;
            if (evasionAngleLimit > 0.0f && source.method_5526() != null) {
                class_243 sourcePos = source.method_5510() != null ? source.method_5510() : source.method_5526().method_19538();
                angleOfAttack = (float)VectorHelper.angleBetween(entity.method_5828(1.0f), new class_243(sourcePos.method_10216() - entity.method_23317(), 0.0, sourcePos.method_10215() - entity.method_23321()));
                angleOfAttack = Math.abs(angleOfAttack);
            }
            return chance > 0.0f && RNG.nextFloat() < chance && angleOfAttack <= evasionAngleLimit;
        }
        return false;
    }

    public static void onEvade(class_1309 entity, float damage, class_1282 source) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            Collection tracker = PlayerLookup.tracking((class_1297)player);
            AnimationHelper.sendAnimation((class_1657)player, tracker, SpellCast.Animation.MISC, "spell_engine:dodge", 1.0f);
        }
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpellEngineSounds.DODGE.soundEvent(), entity.method_5634(), 1.0f, evadeSound.randomizedPitch());
        CombatEvents.ENTITY_EVASION.invoke(listener -> listener.onEntityEvasion(new CombatEvents.EntityEvasion.Args(entity, damage, source)));
    }

    public static interface Evader {
        public class_1282 getLastEvaded();

        public void setLastEvaded(class_1282 var1);
    }
}

