/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.item;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.screen.GrindstoneScreenHandler$4"})
public class GrindstoneSlotOutputMixin {
    @Nullable
    private class_1937 world;

    @Inject(method={"getExperience(Lnet/minecraft/world/World;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExperience_enter_SpellEngine(class_1937 world, CallbackInfoReturnable<Integer> cir) {
        this.world = world;
    }

    @Inject(method={"getExperience(Lnet/minecraft/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExperience_SpellEngine(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (this.world != null && stack.method_31573(SpellEngineItemTags.GRINDABLE)) {
            SpellContainer container = SpellContainerHelper.containerFromItemStack(stack);
            int experience = 0;
            if (container != null) {
                class_2378<Spell> registry = SpellRegistry.from(this.world);
                for (String idString : container.spell_ids()) {
                    class_2960 id = class_2960.method_60654((String)idString);
                    Optional spellEntry = registry.method_55841(id);
                    if (!spellEntry.isPresent()) continue;
                    Spell spell = (Spell)((class_6880.class_6883)spellEntry.get()).comp_349();
                    if (spell.learn == null) continue;
                    experience += spell.tier * spell.learn.level_cost_per_tier;
                }
            }
            if (experience > 0) {
                cir.setReturnValue((Object)experience);
                cir.cancel();
                this.world = null;
            }
        }
    }
}

