/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class SimpleSoundGeneratorV2
implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SimpleSoundGeneratorV2(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generateSounds(Builder var1);

    private static LinkedHashMap<String, Sound> createFileContent(String namespace, List<SoundEntry> soundEntries) {
        LinkedHashMap<String, Sound> map = new LinkedHashMap<String, Sound>();
        for (SoundEntry sound : soundEntries) {
            List<String> soundIds = sound.variants().stream().map(variant -> class_2960.method_60655((String)namespace, (String)variant).toString()).toList();
            map.put(sound.name, new Sound(soundIds));
        }
        return map;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        Builder builder = new Builder();
        this.generateSounds(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            LinkedHashMap<String, Sound> content = SimpleSoundGeneratorV2.createFileContent(entry.namespace(), entry.sounds);
            JsonElement json = gson.toJsonTree(content);
            Path path = this.getFilePath(entry.namespace());
            writes.add(class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String method_10321() {
        return "Simple Sound Entry Generator";
    }

    private Path getFilePath(String namespace) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39368, "").method_44107(class_2960.method_60655((String)namespace, (String)"sounds"));
    }

    public record SoundEntry(String name, List<String> variants) {
        public static SoundEntry withVariants(String name, int count) {
            if (count > 1) {
                ArrayList<String> variants = new ArrayList<String>();
                for (int i = 0; i < count; ++i) {
                    variants.add(name + "_" + (i + 1));
                }
                return new SoundEntry(name, variants);
            }
            return new SoundEntry(name, List.of(name));
        }
    }

    private record Sound(List<String> sounds) {
    }

    public static class Builder {
        public final List<Entry> entries = new ArrayList<Entry>();
    }

    public record Entry(String namespace, List<SoundEntry> sounds) {
    }
}

