/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.weapon;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1322;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9424;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import org.jetbrains.annotations.Nullable;

public class Weapon {
    private static final class_2960 equipmentBonusId = class_2960.method_60654((String)"equipment_bonus");
    private static final class_2960 attackDamageId = class_2960.method_60654((String)"generic.attack_damage");
    private static final class_2960 projectileDamageId = class_2960.method_60655((String)"projectile_damage", (String)"generic");

    public static void register(Map<String, WeaponConfig> configs, List<Entry> entries, class_5321<class_1761> itemGroupKey) {
        for (Entry entry : entries) {
            int tier;
            WeaponConfig config = configs.get(entry.name);
            if (config == null) {
                config = entry.defaults;
                configs.put(entry.name(), config);
            }
            if (!entry.isRequiredModInstalled()) continue;
            class_1792.class_1793 settings = new class_1792.class_1793().method_57348(Weapon.attributesFrom(config));
            if (entry.rarity != class_1814.field_8906) {
                settings = settings.method_7894(entry.rarity);
            }
            if (entry.spells != null) {
                if (entry.spells.isEmpty()) {
                    settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForMagicWeapon());
                } else {
                    settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, entry.spells));
                }
            }
            if ((tier = Tiers.unsafe(entry.id())) >= 3) {
                settings.method_24359();
            }
            class_1792 item = entry.create(entry.material, settings);
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id(), (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
            for (Entry entry : entries) {
                content.method_45421((class_1935)entry.item());
            }
        });
    }

    public static class_9285 attributesFrom(WeaponConfig config) {
        class_9285.class_9286 builder = class_9285.method_57480();
        builder.method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, (double)config.attack_damage, class_1322.class_1323.field_6328), class_9274.field_49217);
        builder.method_57487(class_5134.field_23723, new class_1322(class_1792.field_8001, (double)config.attack_speed, class_1322.class_1323.field_6328), class_9274.field_49217);
        for (AttributeModifier attribute : config.attributes) {
            try {
                class_2960 attributeId = class_2960.method_60654((String)attribute.attribute);
                class_6880.class_6883 entityAttribute = (class_6880.class_6883)class_7923.field_41190.method_55841(attributeId).get();
                builder.method_57487((class_6880)entityAttribute, new class_1322(equipmentBonusId, (double)attribute.value, attribute.operation), class_9274.field_49217);
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.method_57486();
    }

    public static class_9285 attributesFrom(List<AttributeModifier> attributes) {
        class_9285.class_9286 builder = class_9285.method_57480();
        for (AttributeModifier attribute : attributes) {
            try {
                class_2960 attributeId = class_2960.method_60654((String)attribute.attribute);
                class_6880.class_6883 entityAttribute = (class_6880.class_6883)class_7923.field_41190.method_55841(attributeId).get();
                builder.method_57487((class_6880)entityAttribute, new class_1322(equipmentBonusId, (double)attribute.value, attribute.operation), class_9274.field_49217);
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.method_57486();
    }

    public static final class Entry {
        private final String namespace;
        private final String name;
        private final CustomMaterial material;
        private final Factory factory;
        @Nullable
        private class_1792 registeredItem;
        private final WeaponConfig defaults;
        @Nullable
        private String requiredMod;
        public class_1814 rarity = class_1814.field_8906;
        private String translatedName = "";
        public String weaponAttributesPreset = "";
        public List<class_2960> spells = null;
        public Equipment.WeaponType category = Equipment.WeaponType.SWORD;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;

        public Entry(String namespace, String name, CustomMaterial material, Factory factory, WeaponConfig defaults, Equipment.WeaponType category) {
            this.namespace = namespace;
            this.name = name;
            this.material = material;
            this.factory = factory;
            this.defaults = defaults;
            this.category = category;
        }

        public class_2960 id() {
            return class_2960.method_60655((String)this.namespace, (String)this.name);
        }

        public Entry attribute(AttributeModifier attribute) {
            this.defaults.add(attribute);
            return this;
        }

        public Entry requires(String modName) {
            this.requiredMod = modName;
            return this;
        }

        public boolean isRequiredModInstalled() {
            if (this.requiredMod == null || this.requiredMod.isEmpty()) {
                return true;
            }
            return FabricLoader.getInstance().isModLoaded(this.requiredMod);
        }

        public String name() {
            return this.name;
        }

        public CustomMaterial material() {
            return this.material;
        }

        public class_1792 create(class_1832 material, class_1792.class_1793 settings) {
            class_1792 item;
            this.registeredItem = item = this.factory.create(material, settings);
            return item;
        }

        @Nullable
        public class_1792 item() {
            return this.registeredItem;
        }

        public WeaponConfig defaults() {
            return this.defaults;
        }

        @Deprecated
        public Entry tier(int tier) {
            return this;
        }

        @Deprecated
        public int tier() {
            return 0;
        }

        public Entry castSpell() {
            this.spells = List.of();
            return this;
        }

        public Entry spell(class_2960 spellId) {
            this.spells = List.of(spellId);
            return this;
        }

        public Entry translatedName(String name) {
            this.translatedName = name;
            return this;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public Equipment.WeaponType category() {
            return this.category;
        }

        public Entry loot(Equipment.LootProperties properties) {
            this.lootProperties = properties;
            return this;
        }

        public Equipment.LootProperties lootProperties() {
            return this.lootProperties;
        }
    }

    public static class CustomMaterial
    implements class_1832 {
        private class_6862<class_2248> inverseTag;
        private int durability = 0;
        private float miningSpeed = 0.0f;
        private int enchantability = 0;
        private class_3528<class_1856> ingredient = null;

        public static CustomMaterial matching(class_1834 vanillaMaterial, Supplier<class_1856> repairIngredient) {
            CustomMaterial material = new CustomMaterial();
            material.durability = vanillaMaterial.method_8025();
            material.miningSpeed = vanillaMaterial.method_8027();
            material.enchantability = vanillaMaterial.method_8026();
            material.ingredient = new class_3528(repairIngredient);
            material.inverseTag = vanillaMaterial.method_58419();
            return material;
        }

        public int method_8025() {
            return this.durability;
        }

        public float method_8027() {
            return this.miningSpeed;
        }

        public float method_8028() {
            return 0.0f;
        }

        public class_6862<class_2248> method_58419() {
            return this.inverseTag;
        }

        public int method_8026() {
            return this.enchantability;
        }

        public class_1856 method_8023() {
            return (class_1856)this.ingredient.method_15332();
        }

        public class_9424 method_58418(class_6862<class_2248> tag) {
            return super.method_58418(tag);
        }
    }

    public static interface Factory {
        public class_1792 create(class_1832 var1, class_1792.class_1793 var2);
    }
}

