/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.ParticleHelper;
import org.jetbrains.annotations.Nullable;

public class BuffParticleSpawner
implements CustomParticleStatusEffect.Spawner {
    private final ParticleBatch[] particles;
    @Nullable
    private ParticleBatch groundEffect;
    private int groundFrequency = 0;
    private int frequency = 0;
    private boolean invertedFrequency = false;
    private boolean scaleWithAmplifier = true;

    public static ParticleBatch defaultBatch(String particleId, float particleCount) {
        return BuffParticleSpawner.defaultBatch(particleId, particleCount, 0L);
    }

    public static ParticleBatch defaultBatch(String particleId, float particleCount, long color) {
        return BuffParticleSpawner.defaultBatch(particleId, particleCount, 0.11f, 0.12f, color);
    }

    public static ParticleBatch defaultBatch(String particleId, float particleCount, float min_speed, float max_speed) {
        return BuffParticleSpawner.defaultBatch(particleId, particleCount, min_speed, max_speed, 0L);
    }

    public static ParticleBatch defaultBatch(String particleId, float particleCount, float min_speed, float max_speed, long color) {
        ParticleBatch batch = new ParticleBatch(particleId, ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, null, particleCount, min_speed, max_speed, 0.0f, -0.2f);
        if (color != 0L) {
            batch.color(color);
        }
        return batch;
    }

    public BuffParticleSpawner(List<String> particleIds, float particleCount, float min_speed, float max_speed) {
        this.particles = new ParticleBatch[particleIds.size()];
        for (int i = 0; i < particleIds.size(); ++i) {
            this.particles[i] = BuffParticleSpawner.defaultBatch(particleIds.get(i), particleCount, min_speed, max_speed);
        }
    }

    public BuffParticleSpawner(String particleId, float particleCount, float min_speed, float max_speed) {
        this.particles = new ParticleBatch[]{BuffParticleSpawner.defaultBatch(particleId, particleCount, min_speed, max_speed)};
    }

    public BuffParticleSpawner(String particleId, float particleCount) {
        this(particleId, particleCount, 0.11f, 0.12f);
    }

    public BuffParticleSpawner(ParticleBatch particleBatch) {
        this(new ParticleBatch[]{particleBatch});
    }

    public BuffParticleSpawner(ParticleBatch[] particles) {
        this.particles = particles;
    }

    public BuffParticleSpawner withGroundEffect(String particleId, Color color, int frequency) {
        this.groundFrequency = frequency;
        this.groundEffect = new ParticleBatch(particleId.toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).color(color.toRGBA()).followEntity(true);
        return this;
    }

    public BuffParticleSpawner scaleWithAmplifier(boolean scaleWithAmplifier) {
        this.scaleWithAmplifier = scaleWithAmplifier;
        return this;
    }

    public BuffParticleSpawner withFrequency(int frequency) {
        this.frequency = frequency;
        return this;
    }

    public BuffParticleSpawner invertFrequency() {
        this.invertedFrequency = true;
        return this;
    }

    @Override
    public void spawnParticles(class_1309 livingEntity, int amplifier) {
        boolean spawn;
        int time = livingEntity.field_6012;
        boolean bl = this.frequency == 0 || (!this.invertedFrequency ? time % this.frequency == 0 : time % (this.frequency / (amplifier + 1)) == 0) ? true : (spawn = false);
        if (spawn) {
            ParticleBatch[] scaledParticles = new ParticleBatch[this.particles.length];
            int scale = this.scaleWithAmplifier ? amplifier + 1 : 1;
            for (int i = 0; i < this.particles.length; ++i) {
                ParticleBatch copiedBatch = new ParticleBatch(this.particles[i]);
                copiedBatch.count *= (float)scale;
                scaledParticles[i] = copiedBatch;
            }
            ParticleHelper.play(livingEntity.method_37908(), (class_1297)livingEntity, scaledParticles);
        }
        if (this.groundEffect != null && this.groundFrequency > 0 && livingEntity.field_6012 % this.groundFrequency == 0) {
            ParticleHelper.play(livingEntity.method_37908(), (class_1297)livingEntity, this.groundEffect);
        }
    }
}

