/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fx;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;

public class SpellEngineParticles {
    private static final ArrayList<Entry> simples = new ArrayList();
    private static final ArrayList<TemplateEntry> templateEntries = new ArrayList();
    public static final List<MagicParticleFamily> MAGIC_FAMILIES = new ArrayList<MagicParticleFamily>();
    private static final ArrayList<TemplateEntry> area_effects = new ArrayList();
    private static final ArrayList<TemplateEntry> sign_effects = new ArrayList();
    public static final TemplateEntry fire_explosion = SpellEngineParticles.addTemplate(new TemplateEntry("fire_explosion", Texture.of("fire_explosion", 10)));
    public static final Entry flame = SpellEngineParticles.add(new Entry("flame", Texture.vanilla("flame")));
    public static final Entry flame_spark = SpellEngineParticles.add(new Entry("flame_spark", Texture.of("flame_spark", 8)));
    public static final Entry flame_ground = SpellEngineParticles.add(new Entry("flame_ground", Texture.of("flame_ground", 8)));
    public static final Entry flame_medium_a = SpellEngineParticles.add(new Entry("flame_medium_a", Texture.of("flame_medium_a", 8)));
    public static final Entry flame_medium_b = SpellEngineParticles.add(new Entry("flame_medium_b", Texture.of("flame_medium_b", 8)));
    public static final Entry frost_shard = SpellEngineParticles.add(new Entry("frost_shard", Texture.of("frost_shard")));
    public static final Entry snowflake = SpellEngineParticles.add(new Entry("snowflake", Texture.vanilla("generic", 8, true)));
    public static final Entry roots = SpellEngineParticles.add(new Entry("roots", Texture.of("roots", 14)));
    public static final Entry electric_arc_A = SpellEngineParticles.add(new Entry("electric_arc_a", Texture.of("electric_arc_a", 8)));
    public static final Entry electric_arc_B = SpellEngineParticles.add(new Entry("electric_arc_b", Texture.of("electric_arc_b", 8)));
    public static final Entry shield_small = SpellEngineParticles.add(new Entry("shield_small", Texture.of("shield_small")));
    public static final Entry dripping_blood = SpellEngineParticles.add(new Entry("dripping_blood", Texture.vanilla("drip_hang")));
    public static final TemplateEntry smoke_medium = SpellEngineParticles.addTemplate(new TemplateEntry("smoke_medium", Texture.of("smoke_medium", 9)));
    public static final TemplateEntry smoke_large = SpellEngineParticles.addTemplate(new TemplateEntry("smoke_large", Texture.vanilla("big_smoke", 12)));
    public static final TemplateEntry sign_aggro = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_aggro", Texture.of("sign/aggro")));
    public static final TemplateEntry sign_arrow = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_arrow", Texture.of("sign/arrow")));
    public static final TemplateEntry sign_cast = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_cast", Texture.of("sign/cast")));
    public static final TemplateEntry sign_fist = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_fist", Texture.of("sign/fist")));
    public static final TemplateEntry sign_hourglass = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_hourglass", Texture.of("sign/hourglass")));
    public static final TemplateEntry sign_roll = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_roll", Texture.of("sign/roll")));
    public static final TemplateEntry sign_shield = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_shield", Texture.of("sign/shield")));
    public static final TemplateEntry sign_speed = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_speed", Texture.of("sign/speed")));
    public static final TemplateEntry sign_wand = SpellEngineParticles.addSignEffect(new TemplateEntry("sign_wand", Texture.of("sign/wand")));
    public static final TemplateEntry ground_glow = SpellEngineParticles.addAreaEffect(new TemplateEntry("ground_glow", Texture.of("area/ground_glow")).fading(Fading.IN_OUT));
    public static final TemplateEntry area_circle_1 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_circle_1", Texture.of("area/circle_1")).fading(Fading.OUT));
    public static final TemplateEntry area_swirl = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_swirl", Texture.of("area/swirl", 16)));
    public static final TemplateEntry area_effect_293 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_293", Texture.of("area/effect_293", 9)));
    public static final TemplateEntry area_effect_480 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_480", Texture.of("area/effect_480", 12)));
    public static final TemplateEntry area_effect_609 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_609", Texture.of("area/effect_609", 13)));
    public static final TemplateEntry area_effect_658 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_658", Texture.of("area/effect_658", 16)));
    public static final TemplateEntry area_effect_714 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_714", Texture.of("area/effect_714", 22)));
    public static final TemplateEntry area_effect_715 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_715", Texture.of("area/effect_715", 22)));
    public static final TemplateEntry area_effect_741 = SpellEngineParticles.addAreaEffect(new TemplateEntry("area_effect_741", Texture.of("area/effect_741", 23)));
    public static final TemplateEntry aura_effect_409 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_409", Texture.of("aura/effect_409", 10)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_415 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_415", Texture.of("aura/effect_415", 9)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_538 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_538", Texture.of("aura/effect_538", 13)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_553 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_553", Texture.of("aura/effect_553", 13)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_619 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_619", Texture.of("aura/effect_619", 15)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_622 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_622", Texture.of("aura/effect_622", 14)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_642 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_642", Texture.of("aura/effect_642", 14)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_649 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_649", Texture.of("aura/effect_649", 13)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_668 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_668", Texture.of("aura/effect_668", 16)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_691 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_691", Texture.of("aura/effect_691", 16)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_716 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_716", Texture.of("aura/effect_716", 23)).orientation(Orientation.VERTICAL));
    public static final TemplateEntry aura_effect_728 = SpellEngineParticles.addAreaEffect(new TemplateEntry("aura_effect_728", Texture.of("aura/effect_728", 23)).orientation(Orientation.VERTICAL));
    @Deprecated
    public static final Entry weakness_smoke;

    private static class_2400 createSimple() {
        return new Helper(false);
    }

    public static List<Entry> simpleEntries() {
        return simples;
    }

    private static Entry add(Entry simpleEntry) {
        simples.add(simpleEntry);
        return simpleEntry;
    }

    public static List<TemplateEntry> templateEntries() {
        return templateEntries;
    }

    private static TemplateEntry addTemplate(TemplateEntry entry) {
        templateEntries.add(entry);
        return entry;
    }

    public static MagicParticleFamily addMagicFamily(MagicParticleFamily family) {
        MAGIC_FAMILIES.add(family);
        return family;
    }

    public static List<TemplateEntry> areaEffects() {
        return area_effects;
    }

    public static TemplateEntry addAreaEffect(TemplateEntry entry) {
        SpellEngineParticles.addTemplate(entry);
        area_effects.add(entry);
        return entry;
    }

    public static List<TemplateEntry> signEffects() {
        return sign_effects;
    }

    public static TemplateEntry addSignEffect(TemplateEntry entry) {
        SpellEngineParticles.addTemplate(entry);
        sign_effects.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : simples) {
            class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)entry.id, (Object)entry.particleType);
        }
        for (TemplateEntry templateEntry : templateEntries) {
            class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)templateEntry.id, (Object)templateEntry.particleType);
        }
    }

    static {
        for (MagicParticles.Variant variant : MagicParticles.all) {
            SpellEngineParticles.addTemplate(variant.entry());
        }
        weakness_smoke = SpellEngineParticles.add(new Entry("weakness_smoke", Texture.of("smoke_medium", 9)));
    }

    private static class Helper
    extends class_2400 {
        protected Helper(boolean alwaysShow) {
            super(alwaysShow);
        }
    }

    public record TemplateEntry(class_2960 id, Texture texture, TemplateParticleType particleType, Fading fading, Orientation orientation) {
        public TemplateEntry(String name, Texture texture) {
            this(class_2960.method_60655((String)"spell_engine", (String)name), texture);
        }

        public TemplateEntry(class_2960 id, Texture texture) {
            this(id, texture, new TemplateParticleType(), Fading.NONE, Orientation.HORIZONTAL);
        }

        public TemplateEntry fading(Fading fading) {
            return new TemplateEntry(this.id, this.texture, this.particleType, fading, this.orientation);
        }

        public TemplateEntry orientation(Orientation orientation) {
            return new TemplateEntry(this.id, this.texture, this.particleType, this.fading, orientation);
        }
    }

    public record Entry(class_2960 id, Texture texture, class_2400 particleType) {
        public Entry(String name, Texture texture) {
            this(class_2960.method_60655((String)"spell_engine", (String)name), texture);
        }

        public Entry(class_2960 id, Texture texture) {
            this(id, texture, SpellEngineParticles.createSimple());
        }
    }

    public record Texture(class_2960 id, int frames, boolean reverseOrder) {
        public Texture(class_2960 id, int frames) {
            this(id, frames, false);
        }

        public Texture(class_2960 id) {
            this(id, 1, false);
        }

        public static Texture vanilla(String name) {
            return new Texture(class_2960.method_60656((String)name));
        }

        public static Texture vanilla(String name, int frames) {
            return new Texture(class_2960.method_60656((String)name), frames);
        }

        public static Texture vanilla(String name, int frames, boolean reverseOrder) {
            return new Texture(class_2960.method_60656((String)name), frames, reverseOrder);
        }

        public static Texture of(String name) {
            return new Texture(class_2960.method_60655((String)"spell_engine", (String)name));
        }

        public static Texture of(String name, int frames) {
            return new Texture(class_2960.method_60655((String)"spell_engine", (String)name), frames);
        }

        public static Texture of(String name, int frames, boolean reverseOrder) {
            return new Texture(class_2960.method_60655((String)"spell_engine", (String)name), frames, reverseOrder);
        }
    }

    public static enum Fading {
        NONE,
        IN,
        OUT,
        IN_OUT;

    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    public record MagicParticles(String name, Color color) {
        public static final String prefix = "magic";
        public static final List<Variant> all = MagicParticles.variants();

        public static List<Variant> variants() {
            ArrayList<Variant> variants = new ArrayList<Variant>();
            for (Motion motion : Motion.values()) {
                for (Shape shape : Shape.values()) {
                    variants.add(Variant.of(shape, motion));
                }
            }
            return variants;
        }

        public static TemplateEntry get(Shape shape, Motion motion) {
            return all.stream().filter(variant -> variant.shape == shape && variant.motion == motion).map(variant -> variant.entry).findFirst().orElse(null);
        }

        public static enum Motion {
            FLOAT,
            ASCEND,
            DECELERATE,
            BURST;

        }

        public static enum Shape {
            SPELL(8),
            SPARK,
            STRIPE(8, true),
            ARCANE,
            FROST,
            HOLY,
            HEAL,
            SKULL;

            public boolean animated = false;
            int frameCount = 1;

            private Shape() {
            }

            private Shape(int frameCount) {
                this.frameCount = frameCount;
            }

            private Shape(int frameCount, boolean animated) {
                this.frameCount = frameCount;
                this.animated = animated;
            }
        }

        public record Variant(Shape shape, Motion motion, TemplateEntry entry) {
            public static Variant of(Shape shape, Motion motion) {
                class_2960 id = Variant.id(Variant.name(shape, motion));
                Texture texture = Variant.texture(shape);
                return new Variant(shape, motion, new TemplateEntry(id, texture));
            }

            public static class_2960 id(String name) {
                return class_2960.method_60655((String)"spell_engine", (String)name);
            }

            public static String name(Shape shape, Motion motion) {
                return String.format("%s_%s_%s", MagicParticles.prefix, shape.toString().toLowerCase(Locale.ENGLISH), motion.toString().toLowerCase(Locale.ENGLISH));
            }

            public static Texture texture(Shape shape) {
                String folder = "magic/";
                switch (shape.ordinal()) {
                    case 0: {
                        return Texture.vanilla("spell", shape.frameCount, true);
                    }
                    case 1: {
                        return Texture.vanilla("generic_0", shape.frameCount);
                    }
                    case 2: {
                        return Texture.of(folder + "vertical_stripe", shape.frameCount);
                    }
                }
                String name = folder + shape.toString().toLowerCase(Locale.ENGLISH);
                return Texture.of(name, shape.frameCount);
            }
        }
    }

    public record MagicParticleFamily(String name, Color color) {
        public static final String prefix = "magic";

        public List<Variant> variants() {
            ArrayList<Variant> variants = new ArrayList<Variant>();
            for (Motion motion : Motion.values()) {
                for (Shape shape : Shape.values()) {
                    variants.add(new Variant(this, shape, motion, (class_2396)SpellEngineParticles.createSimple()));
                }
            }
            return variants;
        }

        public static enum Motion {
            FLOAT,
            ASCEND,
            DECELERATE,
            BURST;

        }

        public static enum Shape {
            SPELL,
            IMPACT,
            SPARK,
            STRIPE;

        }

        public record Variant(MagicParticleFamily family, Shape shape, Motion motion, class_2396 particleType) {
            public class_2960 id() {
                return class_2960.method_60655((String)"spell_engine", (String)this.name());
            }

            public String familyName() {
                return this.family.name;
            }

            public Color color() {
                return this.family.color;
            }

            public String name() {
                return String.format("%s_%s_%s_%s", MagicParticleFamily.prefix, this.familyName().toLowerCase(Locale.ENGLISH), this.shape.toString().toLowerCase(Locale.ENGLISH), this.motion.toString().toLowerCase(Locale.ENGLISH));
            }

            public int frameCount() {
                return switch (this.shape.ordinal()) {
                    case 0 -> 8;
                    default -> 1;
                };
            }
        }
    }
}

