/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.utils.PatternMatching;
import net.spell_power.api.SpellSchool;

public class SpellModifiers {
    public static List<Spell.Modifier> of(class_1657 player, class_6880<Spell> spellEntry) {
        class_2960 spellId = ((class_5321)spellEntry.method_40230().get()).method_29177();
        SpellContainerSource.Owner owner = (SpellContainerSource.Owner)player;
        List<Spell.Modifier> matchingModifiers = owner.spellModifierCache().get(spellId);
        if (matchingModifiers == null) {
            matchingModifiers = new ArrayList<Spell.Modifier>();
            SpellContainerSource.Result containers = owner.getSpellContainers();
            if (containers != null) {
                for (class_6880<Spell> entry : containers.modifiers()) {
                    Spell spell = (Spell)entry.comp_349();
                    for (Spell.Modifier modifier : spell.modifiers) {
                        if (!PatternMatching.matches(spellEntry, SpellRegistry.KEY, modifier.spell_pattern)) continue;
                        matchingModifiers.add(modifier);
                    }
                }
            }
            owner.spellModifierCache().put(spellId, matchingModifiers);
        }
        return matchingModifiers;
    }

    public static List<Spell.Modifier> ofImpact(class_1657 player, class_6880<Spell> spellEntry, Spell.Impact impact) {
        return SpellModifiers.of(player, spellEntry).stream().filter(modifier -> {
            for (Spell.Modifier.ImpactFilter filter : modifier.impact_filters) {
                if (SpellModifiers.impactMatches(impact, spellEntry, filter)) continue;
                return false;
            }
            return true;
        }).toList();
    }

    private static boolean impactMatches(Spell.Impact impact, class_6880<Spell> spellEntry, Spell.Modifier.ImpactFilter filter) {
        if (filter.school != null) {
            SpellSchool school;
            SpellSchool spellSchool = school = impact.school != null ? impact.school : ((Spell)spellEntry.comp_349()).school;
            if (school != filter.school) {
                return false;
            }
        }
        return filter.type == null || impact.action.type == filter.type;
    }

    public static float cooldownDeduction(class_1657 player, class_6880<Spell> spellEntry) {
        List<Spell.Modifier> modifiers = SpellModifiers.of(player, spellEntry);
        float value = 0.0f;
        for (Spell.Modifier modifier : modifiers) {
            value += modifier.cooldown_duration_deduct;
        }
        return value;
    }
}

