/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_106;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.spell_engine.rpg_series.loot.LootConfig;
import net.spell_engine.spellbinding.SpellBindRandomlyLootFunction;
import net.tiny_config.ConfigManager;

public class LootHelper {
    public static ConfigManager<TagCache> TAG_CACHE = new ConfigManager("tag_cache", (Object)new TagCache()).builder().setDirectory("rpg_series").sanitize(true).build();

    public static void updateTagCache(LootConfig lootConfig) {
        HashSet<String> updatedTags = new HashSet<String>();
        for (Map.Entry<String, LootConfig.Pool> entry : lootConfig.injectors.entrySet()) {
            String tableId = entry.getKey();
            LootConfig.Pool pool = entry.getValue();
            for (LootConfig.Pool.Entry itemInjectorEntry : pool.entries) {
                ArrayList<String> tagsToCache = new ArrayList<String>();
                if (itemInjectorEntry.id != null) {
                    tagsToCache.add(itemInjectorEntry.id);
                }
                if (itemInjectorEntry.filters != null) {
                    tagsToCache.addAll(itemInjectorEntry.filters);
                }
                for (String id : tagsToCache) {
                    String tagString;
                    if (!id.startsWith("#") || updatedTags.contains(tagString = id.substring(1))) continue;
                    class_2960 tagId = class_2960.method_60654((String)tagString);
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
                    ArrayList itemList = new ArrayList();
                    class_7923.field_41178.method_40286(tag).forEach(itemEntry -> {
                        class_2960 itemId = ((class_5321)itemEntry.method_40230().get()).method_29177();
                        itemList.add(itemId.toString());
                    });
                    ((TagCache)LootHelper.TAG_CACHE.value).cache.put(tagString, itemList);
                    updatedTags.add(tagString);
                }
            }
        }
        TAG_CACHE.save();
    }

    public static void configureV2(class_7225.class_7874 registries, class_2960 id, class_52.class_53 tableBuilder, LootConfig config, HashMap<String, class_1792> entries) {
        String tableId = id.toString();
        LootConfig.Pool pool = config.injectors.get(tableId);
        if (pool == null) {
            for (String regex : config.regex_injectors.keySet()) {
                if (!tableId.matches(regex)) continue;
                pool = config.regex_injectors.get(regex);
                break;
            }
        }
        if (pool == null) {
            return;
        }
        float rolls = pool.rolls > 0.0f ? pool.rolls : 1.0f;
        class_55.class_56 lootPoolBuilder = class_55.method_347();
        double attempts = Math.ceil(rolls);
        double chance = (double)pool.rolls / attempts;
        lootPoolBuilder.method_352((class_5658)class_40.method_273((int)((int)attempts), (float)((float)chance)));
        lootPoolBuilder.method_35509((class_5658)class_44.method_32448((float)pool.bonus_rolls));
        for (LootConfig.Pool.Entry entry : pool.entries) {
            List<Object> filters;
            String entryId = entry.id;
            int weight = entry.weight;
            LootConfig.Pool.Entry.Enchant enchant = entry.enchant;
            LootConfig.Pool.Entry.SpellBind spellBind = entry.spell_bind;
            if (entryId == null || entryId.isEmpty()) continue;
            List<String> itemList = entryId.startsWith("#") ? ((TagCache)LootHelper.TAG_CACHE.value).cache.get(entryId.substring(1)) : List.of(entryId);
            List<Object> list = filters = entry.filters != null ? entry.filters : List.of();
            if (itemList == null) {
                System.err.println("RPG Series loot config: failed to resolve itemList for: " + entryId + " (Probably just needs a game restart)");
                continue;
            }
            for (String itemId : itemList) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemId));
                if (item == null) continue;
                class_85.class_86 lootEntry = class_77.method_411((class_1935)item).method_437(weight);
                boolean filtersMatch = entry.filters_lenient ? filters.isEmpty() : true;
                for (String string : filters) {
                    List<String> tag;
                    if (!string.startsWith("#") || (tag = ((TagCache)LootHelper.TAG_CACHE.value).cache.get(string.substring(1))) == null) continue;
                    boolean contains = tag.contains(itemId);
                    if (entry.filters_lenient) {
                        filtersMatch = filtersMatch || contains;
                        continue;
                    }
                    filtersMatch = filtersMatch && contains;
                }
                if (!filtersMatch) continue;
                if (enchant != null && enchant.isValid()) {
                    class_106.class_107 enchantFunction = class_106.method_481((class_7225.class_7874)registries, (class_5658)LootHelper.numberProvider(enchant.min_power, enchant.max_power));
                    lootEntry.method_438((class_117.class_118)enchantFunction);
                }
                if (spellBind != null && spellBind.isValid()) {
                    class_120.class_121<?> function = SpellBindRandomlyLootFunction.builder(spellBind.pool, LootHelper.numberProvider(spellBind.tier_min, spellBind.tier_max), LootHelper.numberProvider(spellBind.count_min, spellBind.count_max));
                    lootEntry.method_438(function);
                }
                lootPoolBuilder.method_351((class_79.class_80)lootEntry);
            }
        }
        tableBuilder.pool(lootPoolBuilder.method_355());
    }

    private static class_5658 numberProvider(float min, float max) {
        if (max <= min) {
            return class_44.method_32448((float)min);
        }
        return class_5662.method_32462((float)min, (float)max);
    }

    private static List<class_6862<class_1792>> tagKeys(List<String> tags) {
        return tags.stream().map(LootHelper::tagKey).toList();
    }

    private static class_6862<class_1792> tagKey(String tag) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)tag));
    }

    public static class TagCache {
        public HashMap<String, List<String>> cache = new HashMap();
    }
}

