/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.set;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.tags.SpellEngineItemTags;
import org.jetbrains.annotations.Nullable;

public class EquipmentSet {
    public static String translationKey(class_6880<Definition> entry) {
        return EquipmentSet.translationKey(((class_5321)entry.method_40230().get()).method_29177());
    }

    public static String translationKey(class_2960 id) {
        return "equipment_set." + id.method_12836() + "." + id.method_12832();
    }

    public static List<Result> collectFrom(List<SourcedItemStack> stacks, class_1937 world) {
        Object items;
        LinkedHashMap<class_2960, LinkedHashMap> sets = new LinkedHashMap<class_2960, LinkedHashMap>();
        for (SourcedItemStack sourcedStack : stacks) {
            class_1799 stack = sourcedStack.itemstack();
            class_2960 component = (class_2960)stack.method_57824(SpellDataComponents.EQUIPMENT_SET);
            if (component == null) continue;
            class_2960 id = component;
            class_6880.class_6883 itemEntry = stack.method_7909().method_40131();
            if (sourcedStack.sourceName.contains("hand") && !stack.method_31573(SpellEngineItemTags.HANDHELD)) continue;
            items = sets.computeIfAbsent(id, k -> new LinkedHashMap());
            ((LinkedHashMap)sets.get(id)).put(itemEntry.method_40237(), stack);
        }
        class_2378 registry = world.method_30349().method_30530(EquipmentSetRegistry.KEY);
        ArrayList<Result> results = new ArrayList<Result>();
        for (Map.Entry entry : sets.entrySet()) {
            class_2960 setId = (class_2960)entry.getKey();
            Optional set = registry.method_55841(setId);
            if (!set.isPresent()) continue;
            items = ((LinkedHashMap)entry.getValue()).values().stream().toList();
            results.add(new Result((class_6880<Definition>)((class_6880)set.get()), (List<class_1799>)items));
        }
        return results;
    }

    public static List<class_9285> attributesFrom(List<Result> results) {
        ArrayList<class_9285> attributeModifiers = new ArrayList<class_9285>();
        for (Result result : results) {
            Definition set = (Definition)result.set.comp_349();
            for (Bonus bonus : set.bonuses) {
                if (result.items().size() < bonus.requiredPieceCount || bonus.attributes == null) continue;
                attributeModifiers.add(bonus.attributes);
            }
        }
        return attributeModifiers;
    }

    public record SourcedItemStack(class_1799 itemstack, String sourceName) {
    }

    public record Result(class_6880<Definition> set, List<class_1799> items) {
    }

    public record Definition(String name, class_6885<class_1792> items, List<Bonus> bonuses) {
        public static final Codec<Definition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Definition::name), (App)class_6895.method_40340((class_5321)class_7924.field_41197).fieldOf("items").forGetter(Definition::items), (App)Bonus.CODEC.listOf().fieldOf("bonuses").forGetter(Definition::bonuses)).apply((Applicative)instance, Definition::new));
    }

    public record Bonus(int requiredPieceCount, @Nullable class_9285 attributes, @Nullable SpellContainer spells) {
        public static final Codec<Bonus> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("required_piece_count").forGetter(Bonus::requiredPieceCount), (App)class_9285.field_49327.optionalFieldOf("attributes").forGetter(Bonus::getAttributes), (App)SpellContainer.CODEC.optionalFieldOf("spells").forGetter(Bonus::getSpells)).apply((Applicative)instance, Bonus::create));

        public Optional<class_9285> getAttributes() {
            return Optional.ofNullable(this.attributes);
        }

        public Optional<SpellContainer> getSpells() {
            return Optional.ofNullable(this.spells);
        }

        public static Bonus create(int requiredPieceCount, Optional<class_9285> attributes, Optional<SpellContainer> spells) {
            return new Bonus(requiredPieceCount, attributes.orElse(null), spells.orElse(null));
        }

        public static Bonus withSpells(int requiredPieceCount, SpellContainer spells) {
            return new Bonus(requiredPieceCount, null, spells);
        }

        public static Bonus withAttributes(int requiredPieceCount, class_9285 attributes) {
            return new Bonus(requiredPieceCount, attributes, null);
        }
    }

    public static interface Owner {
        public List<Result> getActiveEquipmentSets();

        public void setActiveEquipmentSets(List<Result> var1);
    }
}

