/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.utils.PatternMatching;

public class SpellCastCriteria
extends class_4558<Condition> {
    public static final class_2960 ID = class_2960.method_60655((String)"spell_engine", (String)"spell_cast");
    public static final SpellCastCriteria INSTANCE = new SpellCastCriteria();

    public Codec<Condition> method_54937() {
        return Condition.CODEC;
    }

    public void trigger(class_3222 player, class_6880<Spell> spell) {
        this.method_22510(player, condition -> condition.matches(spell));
    }

    public static final class Condition
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<String> spell;
        private final Optional<String> other_spell;
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(Condition::comp_2029), (App)Codec.optionalField((String)"spell", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::spell), (App)Codec.optionalField((String)"other_spell", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::other_spell)).apply((Applicative)instance, Condition::new));

        public Condition(Optional<class_5258> player, Optional<String> spell, Optional<String> other_spell) {
            this.player = player;
            this.spell = spell;
            this.other_spell = other_spell;
        }

        public boolean matches(class_6880<Spell> spellEntry) {
            String pattern;
            if (this.spell().isEmpty() && this.other_spell().isEmpty()) {
                return true;
            }
            if (this.spell().isPresent() && PatternMatching.matches(spellEntry, SpellRegistry.KEY, pattern = this.spell().get())) {
                return true;
            }
            return this.other_spell().isPresent() && PatternMatching.matches(spellEntry, SpellRegistry.KEY, pattern = this.other_spell().get());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Condition.class, "player;spell;other_spell", "player", "spell", "other_spell"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Condition.class, "player;spell;other_spell", "player", "spell", "other_spell"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Condition.class, "player;spell;other_spell", "player", "spell", "other_spell"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<String> spell() {
            return this.spell;
        }

        public Optional<String> other_spell() {
            return this.other_spell;
        }
    }
}

