/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.render.CustomModels;

public class OrbitingEffectRenderer
implements CustomModelStatusEffect.Renderer {
    private List<Model> models;
    private float scale;
    private float horizontalOffset;
    protected float orbitingSpeed = 2.25f;

    public OrbitingEffectRenderer(List<Model> models, float scale, float horizontalOffset) {
        this.models = models;
        this.scale = scale;
        this.horizontalOffset = horizontalOffset;
    }

    @Override
    public void renderEffect(int amplifier, LivingEntity livingEntity, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        matrixStack.pushPose();
        float time = (float)livingEntity.tickCount + delta;
        float initialAngle = time * this.orbitingSpeed - 45.0f;
        float entityScale = livingEntity.getScale();
        float horizontalOffset = this.horizontalOffset * livingEntity.getAgeScale();
        float verticalOffset = livingEntity.getBbHeight() / (2.0f * entityScale);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        int stacks = amplifier + 1;
        float turnAngle = 360.0f / (float)stacks;
        for (int i = 0; i < stacks; ++i) {
            float angle = initialAngle + turnAngle * (float)i;
            this.renderModel(matrixStack, this.scale, verticalOffset, horizontalOffset, angle, itemRenderer, vertexConsumers, light, livingEntity);
        }
        matrixStack.popPose();
    }

    private void renderModel(PoseStack matrixStack, float scale, float verticalOffset, float horizontalOffset, float rotation, ItemRenderer itemRenderer, MultiBufferSource vertexConsumers, int light, LivingEntity livingEntity) {
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(rotation));
        matrixStack.translate(0.0f, verticalOffset, -horizontalOffset);
        matrixStack.scale(scale, scale, scale);
        for (Model model : this.models) {
            matrixStack.pushPose();
            CustomModels.render(model.layer, itemRenderer, model.modelId, matrixStack, vertexConsumers, light, livingEntity.getId());
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public record Model(RenderType layer, ResourceLocation modelId) {
    }
}

