/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class ExternalSpellSchools {
    public static final SpellSchool PHYSICAL_MELEE = new SpellSchool(SpellSchool.Archetype.MELEE, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"physical_melee"), 0xB3B3B3, DamageTypes.PLAYER_ATTACK, Attributes.ATTACK_DAMAGE);
    public static final SpellSchool PHYSICAL_RANGED = new SpellSchool(SpellSchool.Archetype.ARCHERY, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"physical_ranged"), 8412749, DamageTypes.ARROW, ExternalSpellSchools.rangedDamageAttribute());
    public static final SpellSchool DEFENSE = new SpellSchool(SpellSchool.Archetype.MELEE, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"defense"), 0xCCCCCC, DamageTypes.PLAYER_ATTACK, Attributes.ARMOR);
    public static final SpellSchool HEALTH = new SpellSchool(SpellSchool.Archetype.MELEE, ResourceLocation.fromNamespaceAndPath((String)"spell_power", (String)"health"), 0xCC0000, DamageTypes.PLAYER_ATTACK, Attributes.MAX_HEALTH);
    private static boolean initialized = false;

    private static Holder<Attribute> rangedDamageAttribute() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return EntityAttributes_RangedWeapon.DAMAGE.entry;
        }
        return Attributes.ATTACK_DAMAGE;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        ((Attribute)Attributes.ATTACK_DAMAGE.value()).setSyncable(true);
        PHYSICAL_MELEE.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(Attributes.ATTACK_DAMAGE));
        SpellSchools.configureSpellHaste((SpellSchool)PHYSICAL_MELEE);
        SpellSchools.register((SpellSchool)PHYSICAL_MELEE);
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            PHYSICAL_RANGED.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(EntityAttributes_RangedWeapon.DAMAGE.entry));
            PHYSICAL_RANGED.addSource(SpellSchool.Trait.HASTE, SpellSchool.Apply.ADD, query -> {
                double haste = query.entity().getAttributeValue(EntityAttributes_RangedWeapon.HASTE.entry);
                double rate = EntityAttributes_RangedWeapon.HASTE.asMultiplier(haste);
                return rate - 1.0;
            });
        }
        SpellSchools.register((SpellSchool)PHYSICAL_RANGED);
        DEFENSE.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(Attributes.ARMOR));
        SpellSchools.register((SpellSchool)DEFENSE);
        HEALTH.addSource(SpellSchool.Trait.POWER, SpellSchool.Apply.ADD, query -> query.entity().getAttributeValue(Attributes.MAX_HEALTH));
        SpellSchools.register((SpellSchool)HEALTH);
        initialized = true;
    }
}

