/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.spell_engine.compat.container.CustomBundleCompat;
import org.jetbrains.annotations.Nullable;

public class ContainerCompat {
    public static final ArrayList<Function<Player, List<ItemStack>>> providers = new ArrayList();
    public static final List<Resolver> resolvers = new ArrayList<Resolver>();

    public static void addProvider(Function<Player, List<ItemStack>> provider) {
        providers.add(provider);
    }

    public static void init() {
        resolvers.add(itemStack -> {
            BundleContents bundle = (BundleContents)itemStack.get(DataComponents.BUNDLE_CONTENTS);
            if (bundle != null) {
                return new VanillaBundleAdapter(bundle);
            }
            return null;
        });
        if (FabricLoader.getInstance().isModLoaded("bundleapi")) {
            CustomBundleCompat.init();
        }
    }

    @Nullable
    public static Adapter getContainerComponent(ItemStack itemStack) {
        for (Resolver resolver : resolvers) {
            Adapter adapter = resolver.getContainerAdapter(itemStack);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }

    public static interface Resolver {
        public Adapter getContainerAdapter(ItemStack var1);
    }

    public static interface Adapter {
        public int size();

        public ItemStack get(int var1);

        public Adapter createNewWithContents(List<ItemStack> var1);

        public void attachTo(ItemStack var1);
    }

    public record VanillaBundleAdapter(BundleContents component) implements Adapter
    {
        @Override
        public int size() {
            return this.component.size();
        }

        @Override
        public ItemStack get(int index) {
            return this.component.getItemUnsafe(index);
        }

        @Override
        public Adapter createNewWithContents(List<ItemStack> contents) {
            BundleContents.Mutable newBundle = new BundleContents.Mutable(this.component).clearItems();
            for (ItemStack stackToAdd : contents) {
                newBundle.tryInsert(stackToAdd);
            }
            return new VanillaBundleAdapter(newBundle.toImmutable());
        }

        @Override
        public void attachTo(ItemStack itemStack) {
            itemStack.set(DataComponents.BUNDLE_CONTENTS, (Object)this.component);
        }
    }
}

