/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.item;

import java.util.Comparator;
import java.util.function.Function;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.compat.SlotModCompat;
import net.spell_engine.item.ScrollItem;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingBlock;

public class SpellEngineItems {
    public static final LazyLoadedValue<Item> SCROLL = new LazyLoadedValue(() -> {
        Item.Properties settings = new Item.Properties().stacksTo(1);
        SlotModCompat.SpellScrollArs args = new SlotModCompat.SpellScrollArs(settings);
        Function<SlotModCompat.SpellScrollArs, Item> factory = SlotModCompat.spellScrollFactory;
        return factory != null ? factory.apply(args) : new ScrollItem(args.settings());
    });

    public static ISpellBookItem createBook(ResourceLocation poolId) {
        Item.Properties settings = new Item.Properties().stacksTo(1);
        SlotModCompat.SpellBookArs args = new SlotModCompat.SpellBookArs(poolId, settings);
        Function<SlotModCompat.SpellBookArs, ISpellBookItem> factory = SlotModCompat.spellBookFactory;
        return factory != null ? factory.apply(args) : new SpellBookItem(args.poolId(), args.settings());
    }

    public static void register() {
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, Group.KEY, (Object)Group.SPELLS);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)SpellBinding.ID, (Object)SpellBindingBlock.ITEM);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ScrollItem.ID, (Object)((Item)SCROLL.get()));
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            content.accept((ItemLike)SpellBindingBlock.ITEM);
            HolderLookup.RegistryLookup registryWrapper = content.getContext().holders().lookupOrThrow(SpellRegistry.KEY);
            registryWrapper.listElements().sorted(Comparator.comparing(a -> ((ResourceKey)a.unwrapKey().get()).location().getNamespace() + "_" + ((Spell)a.value()).tier + "_" + ((ResourceKey)a.unwrapKey().get()).location().getPath())).forEach(entry -> {
                ItemStack scroll = new ItemStack((ItemLike)SCROLL.get());
                if (ScrollItem.applySpell(scroll, (Holder<Spell>)entry, ScrollItem.resolveSpellPool((HolderLookup<Spell>)registryWrapper, (Holder<Spell>)entry))) {
                    content.accept(scroll);
                }
            });
        });
    }

    public static class Group {
        public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"generic");
        public static ResourceKey<CreativeModeTab> KEY = ResourceKey.create((ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.key(), (ResourceLocation)ID);
        public static CreativeModeTab SPELLS = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)SpellBindingBlock.ITEM)).title((Component)Component.translatable((String)"itemGroup.spell_engine.general")).build();
    }
}

