/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CyclingSlotBackground;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.gui.CustomButton;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.SpellRender;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SpellBindingScreen
extends AbstractContainerScreen<SpellBindingScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"textures/gui/spell_binding.png");
    private static final ResourceLocation PLACEHOLDER_SPELL_BOOK = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"item/placeholder/spell_book");
    private static final ResourceLocation PLACEHOLDER_LAPIS = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"item/placeholder/lapis");
    private static final ResourceLocation PLACEHOLDER_SCROLL = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"item/placeholder/scroll");
    private final CyclingSlotBackground mainSlotIcon = new CyclingSlotBackground(0);
    private final CyclingSlotBackground consumableSlotIcon = new CyclingSlotBackground(1);
    private ItemStack stack;
    private int pageOffset = 0;
    private Button upButton;
    private Button downButton;
    private static final SubTexture PLACEHOLDER_BOOK = new SubTexture(240, 0, 16, 16);
    private static final int PAGE_SIZE = 3;
    private List<ButtonViewModel> buttonViewModels = List.of();
    private static final int BUTTONS_ORIGIN_X = 60;
    private static final int BUTTONS_ORIGIN_Y = 14;
    private static final ResourceLocation RUNES_FONT_ID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"alt");
    private static final Style RUNE_STYLE = Style.EMPTY.withFont(RUNES_FONT_ID);
    private static final int BUTTON_TEXTURE_U = 0;
    private static final int BUTTON_TEXTURE_V = 166;
    private static final int BUTTON_WIDTH = 108;
    private static final int BUTTON_HEIGHT = 19;
    private static final int SPELL_ICON_SIZE = 16;
    private static final int SPELL_ICON_INDENT = (int)Math.ceil(1.5);
    private static final int ORB_INDENT = 1;
    private static final int ORB_ICON_SIZE = 13;
    private static final int ORB_TEXTURE_U = 0;
    private static final int ORB_TEXTURE_V = 242;
    private static final int BOTTOM_TEXT_OFFSET = 10;
    private static final int COLOR_GOOD = 3604224;
    private static final int COLOR_BAD = 0xFC5C5C;
    private static final int COLOR_GOOD_BUT_DISABLED = 4753678;

    public SpellBindingScreen(SpellBindingScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.stack = ItemStack.EMPTY;
    }

    protected void init() {
        super.init();
        int originX = (this.width - this.imageWidth) / 2;
        int originY = (this.height - this.imageHeight) / 2;
        int x = originX + 156;
        int y = originY + 5;
        int width = 16;
        int height = 10;
        this.upButton = new CustomButton(x, y, CustomButton.Type.SMALL_UP, button -> this.pageUp());
        this.upButton.visible = false;
        this.downButton = new CustomButton(x, y + 57 + height + 1, CustomButton.Type.SMALL_DOWN, button -> this.pageDown());
        this.downButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.upButton);
        this.addRenderableWidget((GuiEventListener)this.downButton);
        this.minecraft.gameMode.handleInventoryButtonClick(((SpellBindingScreenHandler)this.menu).containerId, 14999);
    }

    public void containerTick() {
        super.containerTick();
        this.mainSlotIcon.tick(List.of(PLACEHOLDER_SPELL_BOOK));
        this.consumableSlotIcon.tick(List.of(PLACEHOLDER_LAPIS, PLACEHOLDER_SCROLL));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            for (int i = 0; i < this.buttonViewModels.size(); ++i) {
                ButtonViewModel spellButton = this.buttonViewModels.get(i);
                if (!spellButton.mouseOver((int)mouseX, (int)mouseY)) continue;
                this.minecraft.gameMode.handleInventoryButtonClick(((SpellBindingScreenHandler)this.menu).containerId, i);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isPagingEnabled()) {
            return false;
        }
        int i = 0;
        while ((double)i < Math.abs(verticalAmount)) {
            if (verticalAmount > 0.0) {
                this.pageUp();
            } else {
                this.pageDown();
            }
            ++i;
        }
        return true;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
        LocalPlayer player = Minecraft.getInstance().player;
        int lapisCount = ((SpellBindingScreenHandler)this.menu).getLapisCount();
        ItemStack itemStack = (ItemStack)((SpellBindingScreenHandler)this.menu).getItems().get(0);
        block6: for (ButtonViewModel button : this.buttonViewModels) {
            boolean mouseOver = button.mouseOver(mouseX, mouseY);
            if (!mouseOver) continue;
            if (button.spell != null) {
                ArrayList tooltip = Lists.newArrayList();
                boolean showSpellDetails = true;
                switch (button.binding.state) {
                    case ALREADY_APPLIED: {
                        tooltip.add(Component.translatable((String)"gui.spell_engine.spell_binding.already_bound").withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    case NO_MORE_SLOT: {
                        tooltip.add(Component.translatable((String)"gui.spell_engine.spell_binding.no_more_slots").withStyle(ChatFormatting.GRAY));
                        showSpellDetails = false;
                        break;
                    }
                    case APPLICABLE: {
                        int levelCost;
                        int lapisCost;
                        if (button.binding.readyToApply((Player)player, lapisCount)) {
                            tooltip.add(Component.translatable((String)"gui.spell_engine.spell_binding.available").withStyle(ChatFormatting.GREEN));
                            break;
                        }
                        boolean hasRequiredLevels = button.binding.requirements.metRequiredLevel((Player)player);
                        if (button.binding.requirements.requiredLevel() > 0) {
                            tooltip.add(Component.translatable((String)"gui.spell_engine.spell_binding.level_req_fail", (Object[])new Object[]{button.binding.requirements.requiredLevel()}).withStyle(hasRequiredLevels ? ChatFormatting.GRAY : ChatFormatting.RED));
                        }
                        if ((lapisCost = button.binding.requirements.lapisCost()) > 0) {
                            boolean hasEnoughLapis = button.binding.requirements.hasEnoughLapis(lapisCount);
                            MutableComponent lapis = lapisCost == 1 ? Component.translatable((String)"container.enchant.lapis.one") : Component.translatable((String)"container.enchant.lapis.many", (Object[])new Object[]{lapisCost});
                            tooltip.add(lapis.withStyle(hasEnoughLapis ? ChatFormatting.GRAY : ChatFormatting.RED));
                        }
                        if ((levelCost = button.binding.requirements.levelCost()) <= 0) break;
                        boolean hasEnoughLevels = button.binding.requirements.hasEnoughLevelsToSpend((Player)player);
                        MutableComponent levels = levelCost == 1 ? Component.translatable((String)"container.enchant.level.one") : Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{levelCost});
                        tooltip.add(levels.withStyle(hasEnoughLevels ? ChatFormatting.GRAY : ChatFormatting.RED));
                        break;
                    }
                    case INVALID: {
                        continue block6;
                    }
                }
                if (showSpellDetails) {
                    tooltip.add(Component.literal((String)" "));
                    tooltip.addAll(SpellTooltip.spellEntry(button.spell.id(), (Player)player, itemStack, true, 0));
                }
                if (!button.isDetailsPublic) break;
                context.renderComponentTooltip(this.font, (List)tooltip, mouseX, mouseY);
                break;
            }
            if (button.item == null) break;
            boolean mouseOverIcon = button.mouseOverIcon(mouseX, mouseY);
            if (!mouseOverIcon) continue;
            String key = button.item.getDescriptionId() + ".spell_binding.description";
            if (!Language.getInstance().has(key)) break;
            ArrayList tooltip = Lists.newArrayList();
            tooltip.add(button.item.getDescription());
            String rawDescription = Language.getInstance().getOrDefault(key);
            for (String line : rawDescription.split(System.lineSeparator())) {
                tooltip.add(Component.literal((String)line).withStyle(ChatFormatting.GRAY));
            }
            context.renderComponentTooltip(this.font, (List)tooltip, mouseX, mouseY);
            break;
        }
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        Lighting.setupForFlatItems();
        int originX = (this.width - this.imageWidth) / 2;
        int originY = (this.height - this.imageHeight) / 2;
        context.blit(TEXTURE, originX, originY, 0, 0, this.imageWidth, this.imageHeight);
        this.mainSlotIcon.render(this.menu, context, delta, this.leftPos, this.topPos);
        this.consumableSlotIcon.render(this.menu, context, delta, this.leftPos, this.topPos);
        Lighting.setupFor3DItems();
        this.updatePageControls();
        this.updateButtons(originX, originY);
        this.drawButtons(context, mouseX, mouseY);
    }

    private boolean isPagingEnabled() {
        return this.buttonViewModels.size() > 3;
    }

    private int maximalPageOffset() {
        return this.buttonViewModels.size() - 3;
    }

    private boolean hasPageUp() {
        return this.pageOffset > 0;
    }

    private boolean hasPageDown() {
        return this.pageOffset < this.maximalPageOffset();
    }

    private void pageUp() {
        if (this.hasPageUp()) {
            --this.pageOffset;
        }
    }

    private void pageDown() {
        if (this.hasPageDown()) {
            ++this.pageOffset;
        }
    }

    private void restartPaging() {
        this.pageOffset = 0;
    }

    private void updatePageControls() {
        boolean isPaging;
        this.upButton.visible = isPaging = this.isPagingEnabled();
        this.upButton.active = this.hasPageUp();
        this.downButton.visible = isPaging;
        this.downButton.active = this.hasPageDown();
    }

    private void updateButtons(int originX, int originY) {
        ArrayList<ButtonViewModel> buttons = new ArrayList<ButtonViewModel>();
        ItemStack itemStack = (ItemStack)((SpellBindingScreenHandler)this.menu).getItems().get(0);
        int lapisCount = ((SpellBindingScreenHandler)this.menu).getLapisCount();
        SpellBinding.Mode mode = SpellBinding.Mode.values()[((SpellBindingScreenHandler)this.menu).mode[0]];
        LocalPlayer player = Minecraft.getInstance().player;
        try {
            ClientLevel world = Minecraft.getInstance().level;
            block6: for (int i = 0; i < 32; ++i) {
                int rawId = ((SpellBindingScreenHandler)this.menu).spellId[i];
                int levelCost = ((SpellBindingScreenHandler)this.menu).spellLevelCost[i];
                int requirement = ((SpellBindingScreenHandler)this.menu).spellLevelRequirement[i];
                int lapisCost = ((SpellBindingScreenHandler)this.menu).spellLapisCost[i];
                boolean powered = ((SpellBindingScreenHandler)this.menu).spellPoweredByLib[i] == 1;
                boolean shown = i >= this.pageOffset && i < this.pageOffset + 3;
                switch (mode) {
                    case SPELL: {
                        Optional spellEntry = SpellRegistry.from((Level)world).getHolder(rawId);
                        if (spellEntry.isEmpty()) continue block6;
                        ResourceLocation id = ((ResourceKey)((Holder.Reference)spellEntry.get()).unwrapKey().get()).location();
                        SpellBinding.State bindingState = SpellBinding.State.of(id, itemStack, requirement, levelCost, lapisCost);
                        boolean isDetailsPublic = powered || bindingState.state == SpellBinding.State.ApplyState.ALREADY_APPLIED;
                        boolean isEnabled = powered && bindingState.readyToApply((Player)player, lapisCount);
                        MutableComponent text = Component.translatable((String)SpellTooltip.spellTranslationKey(id));
                        if (!isDetailsPublic) {
                            text = text.withStyle(ChatFormatting.OBFUSCATED).withStyle(RUNE_STYLE);
                        }
                        SpellViewModel spell = new SpellViewModel(id, SpellRender.iconTexture(id), (Component)text);
                        ButtonViewModel button = new ButtonViewModel(shown, originX + 60, originY + 14 + (buttons.size() - this.pageOffset) * 19, 108, 19, isEnabled, isDetailsPublic, spell, null, bindingState);
                        buttons.add(button);
                        continue block6;
                    }
                    case BOOK: {
                        if (rawId < 1) continue block6;
                        ISpellBookItem item = SpellBinding.availableSpellBooks(player.level()).get(rawId - 1);
                        SpellBinding.State bindingState = SpellBinding.State.forBook(levelCost, requirement);
                        boolean isEnabled = bindingState.readyToApply((Player)player, lapisCount);
                        ButtonViewModel button = new ButtonViewModel(shown, originX + 60, originY + 14 + (buttons.size() - this.pageOffset) * 19, 108, 19, isEnabled, true, null, (Item)item, bindingState);
                        buttons.add(button);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error when updating Spell Binding Screen buttons");
            System.err.println(e.getMessage());
        }
        this.setButtons(buttons);
    }

    private void setButtons(List<ButtonViewModel> buttons) {
        if (buttons.size() != this.buttonViewModels.size()) {
            this.restartPaging();
        }
        this.buttonViewModels = buttons;
    }

    private void drawButtons(GuiGraphics context, int mouseX, int mouseY) {
        for (ButtonViewModel button : this.buttonViewModels) {
            ButtonState state = button.mouseOver(mouseX, mouseY) ? ButtonState.HOVER : ButtonState.NORMAL;
            this.drawSpellButton(context, button, state);
        }
    }

    private void drawSpellButton(GuiGraphics context, ButtonViewModel viewModel, ButtonState state) {
        if (!viewModel.shown) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        int u = 0;
        int v = 166;
        if (viewModel.isEnabled) {
            switch (state.ordinal()) {
                case 0: {
                    v += 0;
                    break;
                }
                case 1: {
                    v += viewModel.height * 2;
                }
            }
        } else {
            v += viewModel.height;
        }
        context.blit(TEXTURE, viewModel.x, viewModel.y, u, v, viewModel.width, viewModel.height);
        if (viewModel.binding.state == SpellBinding.State.ApplyState.NO_MORE_SLOT) {
            return;
        }
        if (viewModel.spell != null || viewModel.item != null) {
            int goodColor;
            boolean alreadyApplied = viewModel.binding.state == SpellBinding.State.ApplyState.ALREADY_APPLIED;
            boolean isUnlocked = alreadyApplied || viewModel.isEnabled;
            Component text = Component.nullToEmpty((String)"");
            if (viewModel.spell != null) {
                text = viewModel.spell.name();
            }
            if (viewModel.item != null) {
                text = viewModel.item.getDescription();
            }
            context.drawString(this.font, text, viewModel.x + viewModel.height, viewModel.y + SPELL_ICON_INDENT, isUnlocked ? 0xFFFFFF : 0x808080);
            int n = goodColor = viewModel.isEnabled ? 3604224 : 4753678;
            if (!alreadyApplied && viewModel.binding.requirements.requiredLevel() > 0) {
                String levelRequirement = "" + viewModel.binding.requirements.requiredLevel();
                context.drawString(this.font, levelRequirement, viewModel.x + viewModel.width - 2 - this.font.width(levelRequirement), viewModel.y + viewModel.height - 10, viewModel.binding.requirements.metRequiredLevel((Player)player) ? goodColor : 0xFC5C5C);
            }
            context.setColor(1.0f, 1.0f, 1.0f, isUnlocked ? 1.0f : 0.5f);
            RenderSystem.enableBlend();
            if (viewModel.spell != null && viewModel.spell.icon != null) {
                context.blit(viewModel.spell.icon, viewModel.x + SPELL_ICON_INDENT, viewModel.y + SPELL_ICON_INDENT, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (viewModel.item != null) {
                context.renderItem(viewModel.item.getDefaultInstance(), viewModel.x + SPELL_ICON_INDENT, viewModel.y + SPELL_ICON_INDENT);
            }
            if (!alreadyApplied && viewModel.binding.requirements.levelCost() > 0) {
                context.pose().translate(0.0f, 0.0f, 300.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
                context.blit(TEXTURE, viewModel.x + 1, viewModel.y + viewModel.height - 13 - 1, 0, 242, 13, 13);
                String levelCost = "" + viewModel.binding.requirements.levelCost();
                context.drawString(this.font, levelCost, (int)((long)(viewModel.x + 1) + Math.round(7.8)), viewModel.y + viewModel.height - 10, viewModel.binding.requirements.hasEnoughLevelsToSpend((Player)player) ? goodColor : 0xFC5C5C);
                context.pose().translate(0.0f, 0.0f, -300.0f);
            }
        }
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    record ButtonViewModel(boolean shown, int x, int y, int width, int height, boolean isEnabled, boolean isDetailsPublic, @Nullable SpellViewModel spell, @Nullable Item item, SpellBinding.State binding) {
        public boolean mouseOver(int mouseX, int mouseY) {
            if (!this.shown) {
                return false;
            }
            return mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height;
        }

        public boolean mouseOverIcon(int mouseX, int mouseY) {
            if (!this.shown) {
                return false;
            }
            return mouseX > this.x && mouseX < this.x + this.height && mouseY > this.y && mouseY < this.y + this.height;
        }
    }

    record SpellViewModel(ResourceLocation id, ResourceLocation icon, Component name) {
    }

    static enum ButtonState {
        NORMAL,
        HOVER;

    }

    private record SubTexture(int u, int v, int width, int height) {
    }
}

