/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.datagen;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.util.AlwaysGenerate;

public abstract class SpellGenerator
implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> registryLookup;
    protected final FabricDataOutput dataOutput;
    public OutputFormat outputFormat = OutputFormat.COMPACT;
    private static final Gson verboseGSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Spell.class, new DefaultValueSkippingSerializer<Spell>(Spell.class)).create();

    public SpellGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generateSpells(Builder var1);

    private static boolean hasJsonAdapter(Class<?> clazz) {
        return clazz.isAnnotationPresent(JsonAdapter.class);
    }

    private static List<Class<?>> getAllNestedClasses(Class<?> clazz) {
        ArrayList nestedClasses = new ArrayList();
        SpellGenerator.collectNestedClasses(clazz, nestedClasses);
        return nestedClasses;
    }

    private static void collectNestedClasses(Class<?> clazz, List<Class<?>> nestedClasses) {
        for (Class<?> nested : clazz.getDeclaredClasses()) {
            if (nested.isEnum() || SpellGenerator.hasJsonAdapter(nested) || !nested.getPackageName().contains("spell_engine")) continue;
            nestedClasses.add(nested);
            SpellGenerator.collectNestedClasses(nested, nestedClasses);
        }
    }

    private static Gson compactGSON() {
        GsonBuilder gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Spell.class, new DefaultValueSkippingSerializer<Spell>(Spell.class)).registerTypeAdapter(ParticleBatch.class, new DefaultValueSkippingSerializer<ParticleBatch>(ParticleBatch.class)).registerTypeAdapter(Sound.class, new DefaultValueSkippingSerializer<Sound>(Sound.class));
        for (Class<?> nestedClass : SpellGenerator.getAllNestedClasses(Spell.class)) {
            gson = gson.registerTypeAdapter(nestedClass, new DefaultValueSkippingSerializer(nestedClass));
        }
        return gson.create();
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        Builder builder = new Builder();
        this.generateSpells(builder);
        List<Entry> entries = builder.entries;
        Gson gson = this.outputFormat == OutputFormat.COMPACT ? SpellGenerator.compactGSON() : verboseGSON;
        ArrayList writes = new ArrayList();
        for (Entry entry : entries) {
            Spell spell = entry.spell;
            class_2960 spellId = entry.id;
            JsonElement json = gson.toJsonTree((Object)spell);
            writes.add(SpellGenerator.writeOriginalFormat(writer, json, this.getFilePath(spellId)));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    private static CompletableFuture<?> writeOriginalFormat(class_7403 writer, JsonElement json, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8));){
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("  ");
                    Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
                }
                writer.method_43346(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException var10) {
                IOException iOException = var10;
                field_40831.error("Failed to save file to {}", (Object)path, (Object)iOException);
            }
        }, class_156.method_18349());
    }

    public String method_10321() {
        return "Spell Generator";
    }

    private Path getFilePath(class_2960 spellId) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39367, "spell").method_44107(spellId);
    }

    public static enum OutputFormat {
        COMPACT,
        VERBOSE;

    }

    public static class DefaultValueSkippingSerializer<T>
    implements JsonSerializer<T> {
        private final T defaultInstance;
        private static final Gson checkerGson = new GsonBuilder().create();

        public DefaultValueSkippingSerializer(Class<T> clazz) {
            try {
                this.defaultInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create default instance for class: " + clazz.getName(), e);
            }
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            try {
                for (Field field : src.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    Object value = field.get(src);
                    Object defaultValue = field.get(this.defaultInstance);
                    if (value == null || !field.isAnnotationPresent(AlwaysGenerate.class) && DefaultValueSkippingSerializer.objectsJSONEqual(value, defaultValue)) continue;
                    jsonObject.add(field.getName(), context.serialize(value));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing fields", e);
            }
            return jsonObject;
        }

        private boolean isCustomObject(Class<?> clazz) {
            return !clazz.isPrimitive() && !Number.class.isAssignableFrom(clazz) && !Boolean.class.isAssignableFrom(clazz) && !Character.class.isAssignableFrom(clazz) && !String.class.isAssignableFrom(clazz);
        }

        private static boolean objectsJSONEqual(Object a, Object b) {
            String jsonA = checkerGson.toJson(a);
            String jsonB = checkerGson.toJson(b);
            return jsonA.equals(jsonB);
        }
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();

        public void add(class_2960 id, Spell spell) {
            this.entries.add(new Entry(id, spell));
        }
    }

    public record Entry(class_2960 id, Spell spell) {
    }
}

