/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_2378;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.EntityActionsAllowed;

public class StatusEffectClassification {
    private static final Set<class_6880<class_1320>> movementImpairingAttributes = new HashSet<class_6880<class_1320>>();
    private static final Set<class_5321<class_1291>> movementImpairingEffects = new HashSet<class_5321<class_1291>>();

    public static void init() {
        movementImpairingAttributes.add((class_6880<class_1320>)class_5134.field_23719);
        movementImpairingAttributes.add((class_6880<class_1320>)class_5134.field_23720);
        movementImpairingAttributes.add((class_6880<class_1320>)class_5134.field_49078);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> StatusEffectClassification.parse((class_2378<class_1291>)class_7923.field_41174));
    }

    private static void parse(class_2378<class_1291> registry) {
        registry.method_40270().forEach(entry -> {
            class_1291 effect = (class_1291)entry.comp_349();
            effect.method_55650(0, (attribute, modifier) -> {
                if (movementImpairingAttributes.contains(attribute)) {
                    boolean isMovementImpairing = false;
                    double treshold = 0.0;
                    switch (modifier.comp_2450()) {
                        case field_6328: 
                        case field_6330: {
                            treshold = 0.0;
                            break;
                        }
                        case field_6331: {
                            treshold = 1.0;
                        }
                    }
                    if (modifier.comp_2449() < treshold) {
                        isMovementImpairing = true;
                    }
                    if (isMovementImpairing) {
                        movementImpairingEffects.add((class_5321<class_1291>)((class_5321)entry.method_40230().get()));
                    }
                }
            });
        });
    }

    public static boolean isMovementImpairing(class_6880<class_1291> effect) {
        Optional key = effect.method_40230();
        if (key.isEmpty()) {
            return false;
        }
        return movementImpairingEffects.contains(key.get());
    }

    public static boolean disablesMobAI(class_6880<class_1291> effectEntry) {
        class_1291 effect = (class_1291)effectEntry.comp_349();
        EntityActionsAllowed actionsAllowed = ((ActionImpairing)effect).actionsAllowed();
        if (actionsAllowed == null) {
            return false;
        }
        return !actionsAllowed.mobs().canUseAI();
    }
}

