/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.spell_engine.compat.container.CustomBundleCompat;
import org.jetbrains.annotations.Nullable;

public class ContainerCompat {
    public static final ArrayList<Function<class_1657, List<class_1799>>> providers = new ArrayList();
    public static final List<Resolver> resolvers = new ArrayList<Resolver>();

    public static void addProvider(Function<class_1657, List<class_1799>> provider) {
        providers.add(provider);
    }

    public static void init() {
        resolvers.add(itemStack -> {
            class_9276 bundle = (class_9276)itemStack.method_57824(class_9334.field_49650);
            if (bundle != null) {
                return new VanillaBundleAdapter(bundle);
            }
            return null;
        });
        if (FabricLoader.getInstance().isModLoaded("bundleapi")) {
            CustomBundleCompat.init();
        }
    }

    @Nullable
    public static Adapter getContainerComponent(class_1799 itemStack) {
        for (Resolver resolver : resolvers) {
            Adapter adapter = resolver.getContainerAdapter(itemStack);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }

    public static interface Resolver {
        public Adapter getContainerAdapter(class_1799 var1);
    }

    public static interface Adapter {
        public int size();

        public class_1799 get(int var1);

        public Adapter createNewWithContents(List<class_1799> var1);

        public void attachTo(class_1799 var1);
    }

    public record VanillaBundleAdapter(class_9276 component) implements Adapter
    {
        @Override
        public int size() {
            return this.component.method_57426();
        }

        @Override
        public class_1799 get(int index) {
            return this.component.method_57422(index);
        }

        @Override
        public Adapter createNewWithContents(List<class_1799> contents) {
            class_9276.class_9277 newBundle = new class_9276.class_9277(this.component).method_59709();
            for (class_1799 stackToAdd : contents) {
                newBundle.method_57432(stackToAdd);
            }
            return new VanillaBundleAdapter(newBundle.method_57435());
        }

        @Override
        public void attachTo(class_1799 itemStack) {
            itemStack.method_57379(class_9334.field_49650, (Object)this.component);
        }
    }
}

