/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.arrow;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellModifiers;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.internals.arrow.ArrowShootContext;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.mixin.item.RangedWeaponAccessor;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.WorldScheduler;

public class ArrowHelper {
    public static void shootArrow(class_1937 world, class_1309 shooter, class_6880<Spell> spellEntry, SpellHelper.ImpactContext context) {
        ArrowHelper.shootArrow(world, shooter, spellEntry, context, 0);
    }

    public static void shootArrow(class_1937 world, class_1309 shooter, class_6880<Spell> spellEntry, SpellHelper.ImpactContext context, int sequenceIndex) {
        Spell spell = (Spell)spellEntry.comp_349();
        Spell.Delivery.ShootArrow shoot_arrow = spell.deliver.shoot_arrow;
        class_1799 weaponStack = shooter.method_6047();
        class_1792 weapon = class_1802.field_8399;
        if (shoot_arrow != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (weapon instanceof class_1811) {
                class_1799 ammo;
                class_1811 rangedWeapon = (class_1811)weapon;
                Spell.LaunchProperties mutableLaunchProperties = shoot_arrow.launch_properties.copy();
                if (shooter instanceof class_1657) {
                    class_1657 player = (class_1657)shooter;
                    List<Spell.Modifier> spellModifiers = SpellModifiers.of(player, spellEntry);
                    for (Spell.Modifier modifier : spellModifiers) {
                        if (modifier.projectile_launch == null) continue;
                        mutableLaunchProperties.mutatingCombine(modifier.projectile_launch);
                    }
                }
                if (shooter instanceof class_1657) {
                    class_1657 player = (class_1657)shooter;
                    ammo = player.method_18808(weaponStack);
                } else {
                    ammo = new class_1799((class_1935)class_1802.field_8107);
                }
                List<class_1799> loadedAmmo = RangedWeaponAccessor.load_SpellEngine(weaponStack, ammo, shooter);
                if (loadedAmmo.isEmpty()) {
                    return;
                }
                if (shooter instanceof SpellCasterEntity) {
                    SpellCasterEntity caster = (SpellCasterEntity)shooter;
                    ArrowShootContext shotContext = new ArrowShootContext();
                    shotContext.firedBySpell = true;
                    shotContext.activeSpells.add(spellEntry);
                    caster.setArrowShootContext(shotContext);
                }
                float divergence = sequenceIndex == 0 ? 0.0f : shoot_arrow.divergence;
                ((RangedWeaponAccessor)rangedWeapon).shootAll_SpellEngine(serverWorld, shooter, class_1268.field_5808, weaponStack, loadedAmmo, shoot_arrow.launch_properties.velocity, divergence, shoot_arrow.arrow_critical_strike, null);
                if (weapon instanceof class_1753) {
                    world.method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + 0.5f);
                }
                if (shooter instanceof SpellCasterEntity) {
                    SpellCasterEntity caster = (SpellCasterEntity)shooter;
                    caster.setArrowShootContext(ArrowShootContext.EMPTY);
                }
                int extra_launch = mutableLaunchProperties.extra_launch_count;
                if (sequenceIndex == 0 && extra_launch > 0) {
                    for (int i = 0; i < extra_launch; ++i) {
                        int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                        int nextSequenceIndex = i + 1;
                        ((WorldScheduler)world).schedule(ticks, () -> {
                            if (shooter == null || !shooter.method_5805()) {
                                return;
                            }
                            ArrowHelper.shootArrow(world, shooter, spellEntry, context, nextSequenceIndex);
                        });
                    }
                }
            }
        }
    }

    public static void onArrowShot(ArrowExtension arrow, class_1309 shooter, class_6880<Spell> spellEntry, Supplier<Collection<class_3222>> trackers) {
        if (((Spell)spellEntry.comp_349()).arrow_perks != null) {
            Spell.ArrowPerks arrowPerks = ((Spell)spellEntry.comp_349()).arrow_perks;
            class_1937 world = shooter.method_37908();
            arrow.applyArrowPerks(spellEntry);
            ParticleHelper.sendBatches((class_1297)shooter, arrowPerks.launch_particles, 1.0f, trackers.get());
            SoundHelper.playSound(world, (class_1297)shooter, arrowPerks.launch_sound);
        }
    }
}

