/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fabric.compat;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.spell_engine.compat.accessories.AccessoriesCompat;
import net.spell_engine.fabric.compat.FabricCompatConfig;
import net.spell_engine.fabric.compat.trinkets.TrinketsCompat;
import net.tiny_config.ConfigManager;

public class FabricCompatFeatures {
    private static final ConfigManager<FabricCompatConfig> config = new ConfigManager("fabric_compatibility", (Object)new FabricCompatConfig()).builder().setDirectory("spell_engine").sanitize(true).build();

    private static FabricCompatConfig safeConfig() {
        return (FabricCompatConfig)config.safeValue();
    }

    public static void initialize() {
        FabricCompatFeatures.initSlotCompat();
    }

    public static String initSlotCompat() {
        LinkedHashMap<String, Supplier> compatLoaders = new LinkedHashMap<String, Supplier>();
        if (FabricLoader.getInstance().isModLoaded("accessories")) {
            compatLoaders.put("accessories", AccessoriesCompat::init);
        }
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            compatLoaders.put("trinkets", TrinketsCompat::init);
        }
        String preferredId = FabricCompatFeatures.safeConfig().preferred_slot_mod_id;
        Supplier preferred = (Supplier)compatLoaders.get(FabricCompatFeatures.safeConfig().preferred_slot_mod_id);
        if (preferred != null) {
            compatLoaders.remove(preferredId);
            compatLoaders.putFirst(preferredId, preferred);
        }
        for (Map.Entry entry : compatLoaders.entrySet()) {
            if (!((Boolean)((Supplier)entry.getValue()).get()).booleanValue()) continue;
            return (String)entry.getKey();
        }
        return null;
    }
}

