/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.client.gui.HudMessages;

public record EntityActionsAllowed(boolean canJump, boolean canMove, PlayersAllowed players, MobsAllowed mobs, SemanticType reason) {
    public static final EntityActionsAllowed ANY = new EntityActionsAllowed(true, true, new PlayersAllowed(true, true, true), new MobsAllowed(true), SemanticType.NONE);
    public static final EntityActionsAllowed SILENCE = new EntityActionsAllowed(true, true, new PlayersAllowed(true, true, false), new MobsAllowed(true), SemanticType.SILENCE);
    public static final EntityActionsAllowed INCAPACITATE = new EntityActionsAllowed(true, true, new PlayersAllowed(false, false, false), new MobsAllowed(false), SemanticType.INCAPACITATE);
    public static final EntityActionsAllowed STUN = new EntityActionsAllowed(false, false, new PlayersAllowed(false, false, false), new MobsAllowed(false), SemanticType.STUN);

    public static EntityActionsAllowed fromEffects(Collection<Holder<MobEffect>> effects) {
        EntityActionsAllowed initial = ANY;
        List<EntityActionsAllowed> limiters = effects.stream().map(effect -> ((ActionImpairing)effect.value()).actionsAllowed()).filter(Objects::nonNull).toList();
        if (limiters.size() == 0) {
            return initial;
        }
        boolean canJump = initial.canJump();
        boolean canMove = initial.canMove();
        boolean canAttack = initial.players().canAttack();
        boolean canUseItem = initial.players().canUseItem();
        boolean canCastSpell = initial.players().canCastSpell();
        boolean canUseAI = initial.mobs().canUseAI();
        SemanticType reason = initial.reason();
        for (EntityActionsAllowed impairing : limiters) {
            canJump = canJump && impairing.canJump();
            canMove = canMove && impairing.canMove();
            canAttack = canAttack && impairing.players().canAttack();
            canUseItem = canUseItem && impairing.players().canUseItem();
            canCastSpell = canCastSpell && impairing.players().canCastSpell();
            canUseAI = canUseAI && impairing.mobs().canUseAI();
            reason = impairing.reason().ordinal() > reason.ordinal() ? impairing.reason() : reason;
        }
        return new EntityActionsAllowed(canJump, canMove, new PlayersAllowed(canAttack, canUseItem, canCastSpell), new MobsAllowed(canUseAI), reason);
    }

    public static boolean isImpaired(LivingEntity entity, Common action) {
        EntityActionsAllowed actionsAllowed = ((ControlledEntity)entity).actionImpairing();
        boolean allowed = true;
        switch (action.ordinal()) {
            case 0: {
                allowed = actionsAllowed.canMove();
                break;
            }
            case 1: {
                allowed = actionsAllowed.canJump();
            }
        }
        return !allowed;
    }

    public static boolean isImpaired(LivingEntity player, Player action) {
        return EntityActionsAllowed.isImpaired(player, action, false);
    }

    public static boolean isImpaired(LivingEntity player, Player action, boolean showError) {
        boolean allowed = true;
        EntityActionsAllowed actionsAllowed = ((ControlledEntity)player).actionImpairing();
        switch (action.ordinal()) {
            case 0: {
                allowed = actionsAllowed.players().canAttack();
                break;
            }
            case 1: {
                allowed = actionsAllowed.players().canUseItem();
                break;
            }
            case 2: {
                allowed = actionsAllowed.players().canCastSpell();
            }
        }
        if (player.level().isClientSide && showError && !allowed) {
            HudMessages.INSTANCE.actionImpaired(actionsAllowed.reason());
        }
        return !allowed;
    }

    public static boolean isImpaired(LivingEntity entity, Mob action) {
        EntityActionsAllowed actionsAllowed = ((ControlledEntity)entity).actionImpairing();
        boolean allowed = true;
        switch (action.ordinal()) {
            case 0: {
                allowed = actionsAllowed.mobs().canUseAI();
            }
        }
        return !allowed;
    }

    public record PlayersAllowed(boolean canAttack, boolean canUseItem, boolean canCastSpell) {
    }

    public record MobsAllowed(boolean canUseAI) {
    }

    public static enum SemanticType {
        NONE,
        SILENCE,
        INCAPACITATE,
        STUN;

    }

    public static interface ControlledEntity {
        public EntityActionsAllowed actionImpairing();

        public void updateEntityActionsAllowed();
    }

    public static enum Common {
        MOVE,
        JUMP;

    }

    public static enum Player {
        ATTACK,
        ITEM_USE,
        CAST_SPELL;

    }

    public static enum Mob {
        USE_AI;

    }
}

