/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.tags;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class SpellEngineEntityTags {
    public static final TagKey<EntityType<?>> bosses = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"bosses"));
    public static final TagKey<EntityType<?>> mechanical = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"mechanical"));

    public static class Vulnerability {
        public static final List<Entry> ALL = new ArrayList<Entry>();
        public static final Entry WEAK_TO_FIRE = Vulnerability.add(new Entry(SpellSchools.FIRE, Category.WEAK_TO, List.of(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES)));
        public static final Entry WEAK_TO_FROST = Vulnerability.add(new Entry(SpellSchools.FROST, Category.WEAK_TO, List.of(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)));
        public static final Entry RESISTANT_TO_FROST = Vulnerability.add(new Entry(SpellSchools.FROST, Category.RESISTANT_TO, List.of(EntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES)));
        public static final Entry WEAK_TO_HOLY = Vulnerability.add(new Entry(SpellSchools.HEALING, Category.WEAK_TO, List.of(EntityTypeTags.UNDEAD)));

        public static Entry add(Entry entry) {
            ALL.add(entry);
            return entry;
        }

        public record Entry(SpellSchool school, Category category, List<TagKey<EntityType<?>>> included) {
            public ResourceLocation id() {
                return ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)("vulnerability/" + this.category.name().toLowerCase() + "_" + this.school.id.getPath()));
            }

            public TagKey<EntityType<?>> tag() {
                return TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)this.id());
            }
        }

        static enum Category {
            WEAK_TO,
            RESISTANT_TO;

        }
    }
}

