/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client;

import java.util.LinkedHashMap;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.locale.Language;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.fx.ParticleHelper;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.internals.container.SpellAssignments;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.network.Packets;

public class ClientNetwork {
    public static void initializeHandlers() {
        ClientConfigurationNetworking.registerGlobalReceiver(Packets.ConfigSync.PACKET_ID, (packet, context) -> {
            SpellEngineMod.config = packet.config();
            context.responseSender().sendPacket((CustomPacketPayload)new Packets.Ack("spell_engine:config"));
        });
        ClientConfigurationNetworking.registerGlobalReceiver(Packets.SpellRegistrySync.PACKET_ID, (packet, context) -> {
            SpellAssignments.decodeContent(packet.chunks());
            context.responseSender().sendPacket((CustomPacketPayload)new Packets.Ack("spell_engine:spell_registry"));
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.ParticleBatches.PACKET_ID, (packet, context) -> {
            Minecraft client = context.client();
            List<ParticleHelper.SpawnInstruction> instructions = ParticleHelper.convertToInstructions((Level)client.level, packet);
            client.execute(() -> {
                for (ParticleHelper.SpawnInstruction instruction : instructions) {
                    instruction.perform((Level)client.level);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellAnimation.PACKET_ID, (packet, context) -> {
            Minecraft client = context.client();
            client.execute(() -> {
                Entity entity = client.level.getEntity(packet.playerId());
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ((AnimatablePlayer)player).playSpellAnimation(packet.type(), packet.name(), packet.speed());
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellCooldown.PACKET_ID, (packet, context) -> {
            Minecraft client = context.client();
            client.execute(() -> ((SpellCasterEntity)client.player).getCooldownManager().set(packet.spellId(), packet.duration()));
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellMessage.PACKET_ID, (packet, context) -> {
            Minecraft client = context.client();
            client.execute(() -> {
                String translation = Language.getInstance().getOrDefault(packet.translationKey());
                HudMessages.INSTANCE.error(translation);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellCooldownSync.PACKET_ID, (packet, context) -> {
            Minecraft client = context.client();
            client.execute(() -> {
                SpellCooldownManager cooldownManager = ((SpellCasterEntity)client.player).getCooldownManager();
                List<ResourceLocation> cooldownsBefore = cooldownManager.spellsOnCooldown();
                cooldownManager.acceptSync(packet.baseTick(), packet.cooldowns());
                List<ResourceLocation> cooldownsAfter = cooldownManager.spellsOnCooldown();
                HudMessages.INSTANCE.onCooldownsChanged(cooldownsBefore, cooldownsAfter);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.SpellContainerSync.PACKET_ID, (packet, context) -> {
            Minecraft client = context.client();
            client.execute(() -> {
                LocalPlayer player = client.player;
                if (player != null) {
                    LinkedHashMap<String, SpellContainer> containers = ((SpellContainerSource.Owner)player).serverSideSpellContainers();
                    containers.clear();
                    containers.putAll(packet.containers());
                }
                SpellContainerSource.setDirty((Player)client.player, SpellContainerSource.MAIN_HAND);
            });
        });
    }
}

