/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SpellAreaParticle
extends TextureSheetParticle {
    @Nullable
    Entity followEntity;
    public SpellEngineParticles.Fading fading = SpellEngineParticles.Fading.NONE;
    public SpellEngineParticles.Orientation orientation = SpellEngineParticles.Orientation.HORIZONTAL;
    private final SpriteSet spriteProvider;
    private float initialAlpha = 1.0f;
    private float initialScale = 1.0f;
    private Vec3 ownerPositionDiff = Vec3.ZERO;
    private boolean skipRender = false;
    private boolean scaleWithEntity = false;
    private static final float EASE_DURATION = 0.3f;
    private static final float EASE_DURATION_INVERSE = 3.3333333f;

    protected SpellAreaParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
    }

    private void postInit() {
        this.initialAlpha = this.alpha;
        this.initialScale = this.quadSize;
        if (this.followEntity != null) {
            this.ownerPositionDiff = new Vec3(this.x - this.followEntity.getX(), this.y - this.followEntity.getY(), this.z - this.followEntity.getZ());
            this.checkSkip();
        }
    }

    public int getLightColor(float tint) {
        return 255;
    }

    public void move(double dx, double dy, double dz) {
        if (this.followEntity != null && !this.followEntity.isRemoved()) {
            this.ownerPositionDiff = this.ownerPositionDiff.add(dx, dy, dz);
            Vec3 newPos = this.followEntity.position().add(this.ownerPositionDiff);
            this.setPos(newPos.x, newPos.y, newPos.z);
        } else {
            this.setBoundingBox(this.getBoundingBox().move(dx, dy, dz));
            this.setLocationFromBoundingbox();
        }
    }

    public void tick() {
        super.tick();
        this.checkSkip();
        if (this.age < this.lifetime) {
            this.setSpriteFromAge(this.spriteProvider);
            this.updateAlpha(this.fading, this.initialAlpha);
            this.updateScale();
        }
    }

    private void checkSkip() {
        this.skipRender = this.orientation == SpellEngineParticles.Orientation.VERTICAL && this.followEntity == Minecraft.getInstance().getCameraEntity() && Minecraft.getInstance().options.getCameraType().isFirstPerson();
    }

    private void updateScale() {
        Entity entity;
        if (this.scaleWithEntity && this.followEntity != null && !this.followEntity.isRemoved() && (entity = this.followEntity) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.quadSize = this.initialScale * livingEntity.getScale();
        } else {
            this.quadSize = this.initialScale;
        }
    }

    private void updateAlpha(SpellEngineParticles.Fading fading, float initialAlpha) {
        switch (fading) {
            case NONE: {
                return;
            }
            case IN: {
                float progress = (float)this.age / (float)this.lifetime;
                this.alpha = initialAlpha * Math.min(1.0f, progress * 3.3333333f);
                break;
            }
            case OUT: {
                float progress = (float)this.age / (float)this.lifetime;
                this.alpha = initialAlpha * Math.min(1.0f, (1.0f - progress) * 3.3333333f);
                break;
            }
            case IN_OUT: {
                float progress = (float)this.age / (float)this.lifetime;
                this.alpha = initialAlpha * Math.min(1.0f, Math.min(progress, 1.0f - progress) * 3.3333333f);
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        if (this.skipRender) {
            return;
        }
        switch (this.orientation) {
            case HORIZONTAL: {
                this.buildHorizontalGeometry(vertexConsumer, camera, tickDelta);
                break;
            }
            case VERTICAL: {
                super.render(vertexConsumer, camera, tickDelta);
            }
        }
    }

    private void buildHorizontalGeometry(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternionf quaternion2;
        Vec3 vec3d = camera.getPosition();
        float f = (float)(Mth.lerp((double)tickDelta, (double)this.xo, (double)this.x) - vec3d.x());
        float g = (float)(Mth.lerp((double)tickDelta, (double)this.yo, (double)this.y) - vec3d.y());
        float h = (float)(Mth.lerp((double)tickDelta, (double)this.zo, (double)this.z) - vec3d.z());
        if (this.roll == 0.0f) {
            quaternion2 = camera.rotation();
        } else {
            quaternion2 = new Quaternionf((Quaternionfc)camera.rotation());
            float i = Mth.lerp((float)tickDelta, (float)this.oRoll, (float)this.roll);
            quaternion2.rotateZ(i);
        }
        Vector3f vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        vec3f.rotate((Quaternionfc)quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.getQuadSize(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            Vec3f2.rotate((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.toRadians(90.0), -0.0f, 0.0f));
            Vec3f2.mul(j);
            Vec3f2.add(f, g, h);
        }
        float minU = this.getU0();
        float maxU = this.getU1();
        float minV = this.getV0();
        float maxV = this.getV1();
        int l = this.getLightColor(tickDelta);
        vertexConsumer.addVertex(Vec3fs[0].x(), Vec3fs[0].y(), Vec3fs[0].z()).setUv(maxU, maxV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
        vertexConsumer.addVertex(Vec3fs[1].x(), Vec3fs[1].y(), Vec3fs[1].z()).setUv(maxU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
        vertexConsumer.addVertex(Vec3fs[2].x(), Vec3fs[2].y(), Vec3fs[2].z()).setUv(minU, minV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
        vertexConsumer.addVertex(Vec3fs[3].x(), Vec3fs[3].y(), Vec3fs[3].z()).setUv(minU, maxV).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(l);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<TemplateParticleType> {
        private final SpriteSet spriteProvider;
        private final SpellEngineParticles.Texture texture;
        private final SpellEngineParticles.Fading fading;
        private final SpellEngineParticles.Orientation orientation;
        private final boolean isAura;

        public Factory(SpriteSet spriteProvider, SpellEngineParticles.Texture texture, SpellEngineParticles.Fading fading, SpellEngineParticles.Orientation orientation) {
            this.spriteProvider = spriteProvider;
            this.texture = texture;
            this.fading = fading;
            this.orientation = orientation;
            this.isAura = texture.id().toString().contains("aura");
        }

        public Particle createParticle(TemplateParticleType particleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellAreaParticle particle = new SpellAreaParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.xd = g;
            particle.yd = h;
            particle.zd = i;
            particle.speedUpWhenYMotionIsBlocked = false;
            particle.orientation = this.orientation;
            particle.rCol = 1.0f;
            particle.gCol = 1.0f;
            particle.bCol = 1.0f;
            if (this.texture.frames() > 1) {
                particle.lifetime = this.texture.frames();
            } else {
                particle.lifetime = 16;
            }
            particle.quadSize = 1.0f;
            TemplateParticleType.apply(particleType, (Particle)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.alpha *= appearance.color.alpha();
                }
                particle.quadSize *= appearance.scale;
                particle.lifetime = (int)((float)particle.lifetime * appearance.max_age);
                particle.followEntity = appearance.entityFollowed;
            }
            particle.fading = this.fading;
            particle.scaleWithEntity = this.isAura;
            particle.postInit();
            return particle;
        }
    }
}

