/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.particle.TemplateParticleType;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SpellFlameParticle
extends RisingParticle {
    boolean glow = true;
    boolean translucent = false;
    private SpriteSet spriteProviderForAnimation = null;
    @Nullable
    Entity followEntity;
    private Vec3 ownerPositionDiff = Vec3.ZERO;

    public SpellFlameParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
        super(clientWorld, d, e, f, g, h, i);
    }

    public ParticleRenderType getRenderType() {
        return this.translucent ? ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT : ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void move(double dx, double dy, double dz) {
        if (this.followEntity != null && !this.followEntity.isRemoved()) {
            this.ownerPositionDiff = this.ownerPositionDiff.add(dx, dy, dz);
            Vec3 newPos = this.followEntity.position().add(this.ownerPositionDiff);
            this.setPos(newPos.x, newPos.y, newPos.z);
        } else {
            this.setBoundingBox(this.getBoundingBox().move(dx, dy, dz));
            this.setLocationFromBoundingbox();
        }
    }

    public float getQuadSize(float tickDelta) {
        float f = ((float)this.age + tickDelta) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public int getLightColor(float tint) {
        if (this.glow) {
            return 255;
        }
        return super.getLightColor(tint);
    }

    public void tick() {
        super.tick();
        if (this.spriteProviderForAnimation != null) {
            this.setSpriteFromAge(this.spriteProviderForAnimation);
        }
    }

    private void moveWithFollowed() {
        if (this.followEntity != null && !this.followEntity.isRemoved()) {
            this.x += this.followEntity.getX() - this.followEntity.xo;
            this.y += this.followEntity.getY() - this.followEntity.yo;
            this.z += this.followEntity.getZ() - this.followEntity.zo;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SignFactory
    implements ParticleProvider<TemplateParticleType> {
        private final SpriteSet spriteProvider;
        private final SpellEngineParticles.Texture texture;

        public SignFactory(SpriteSet spriteProvider, SpellEngineParticles.Texture texture) {
            this.spriteProvider = spriteProvider;
            this.texture = texture;
        }

        @Nullable
        public Particle createParticle(TemplateParticleType particleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            particle.friction = 0.7f;
            particle.quadSize = 0.4f;
            particle.alpha = 0.9f;
            particle.translucent = true;
            particle.rCol = 1.0f;
            particle.gCol = 1.0f;
            particle.bCol = 1.0f;
            particle.lifetime = this.texture.frames() > 1 ? this.texture.frames() : 40;
            TemplateParticleType.apply(particleType, (Particle)particle);
            TemplateParticleEffect.Appearance appearance = particleType.getAppearance();
            if (appearance != null) {
                Color color = appearance.color;
                if (color != null) {
                    particle.alpha *= appearance.color.alpha();
                }
                particle.quadSize *= appearance.scale;
                particle.followEntity = appearance.entityFollowed;
            }
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BuffRageFactory
    extends BuffFactory {
        public BuffRageFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.RAGE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BuffFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public BuffFactory(SpriteSet spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            particle.lifetime = 16;
            particle.translucent = true;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NatureSlowingFactory
    extends NatureFactory {
        public NatureSlowingFactory(SpriteSet spriteProvider) {
            super(spriteProvider);
        }

        @Override
        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = (SpellFlameParticle)super.createParticle(SimpleParticleType2, clientWorld, d, e, f, g, h, i);
            particle.friction = 0.8f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WhiteFactory
    extends ColorableFactory {
        public WhiteFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.WHITE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class NatureFactory
    extends ColorableFactory {
        public NatureFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.NATURE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HolyFactory
    extends ColorableFactory {
        public HolyFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.HOLY);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HealingFactory
    extends ColorableFactory {
        public HealingFactory(SpriteSet spriteProvider) {
            super(spriteProvider, Color.from(SpellSchools.HEALING.color));
        }
    }

    public static class ColorableFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0xFFFFFF);

        public ColorableFactory(SpriteSet spriteProvider, Color color) {
            this.spriteProvider = spriteProvider;
            this.color = color;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FrostShard
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.FROST;

        public FrostShard(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(color.red() * j, color.green() * j, color.blue() * j);
            particle.yd *= clientWorld.random.nextFloat() * 0.2f + 0.9f;
            particle.lifetime = Math.round(clientWorld.random.nextFloat() * 3.0f) + 5;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MediumFlameFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public MediumFlameFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.quadSize = 0.5f;
            particle.lifetime = (int)((double)particle.lifetime * 0.5);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WeaknessSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public Color color = Color.from(0x993333);

        public WeaknessSmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(this.color.red() * j, this.color.green() * j, this.color.blue() * j);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.friction = 0.8f;
            particle.setAlpha(0.7f);
            particle.glow = false;
            particle.gravity = 0.01f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SmokeFactory
    implements ParticleProvider<TemplateParticleType> {
        private final SpriteSet spriteProvider;

        public SmokeFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(TemplateParticleType templateParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            particle.setColor(1.0f, 1.0f, 1.0f);
            TemplateParticleType.apply(templateParticleType, (Particle)particle);
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(particle.rCol * j, particle.gCol * j, particle.bCol * j);
            particle.spriteProviderForAnimation = this.spriteProvider;
            particle.friction = 0.8f;
            particle.alpha *= 0.8f;
            particle.glow = false;
            particle.gravity = -0.01f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ElectricSparkFactory
    extends ColoredAnimatedFactory {
        public ElectricSparkFactory(SpriteSet spriteProvider) {
            super(Color.ELECTRIC, 0.75f, spriteProvider);
            this.randomColorRange = 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ColoredAnimatedFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        private final Color color;
        private final float scale;
        protected float randomColorFloor = 0.5f;
        protected float randomColorRange = 0.35f;

        public ColoredAnimatedFactory(Color color, float scale, SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
            this.color = color;
            this.scale = scale;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            float red = this.color.red();
            float green = this.color.green();
            float blue = this.color.blue();
            if (this.randomColorRange > 0.0f) {
                red = (clientWorld.random.nextFloat() * this.randomColorFloor + this.randomColorRange) * red;
                green = (clientWorld.random.nextFloat() * this.randomColorFloor + this.randomColorRange) * green;
                blue = (clientWorld.random.nextFloat() * this.randomColorFloor + this.randomColorRange) * blue;
            }
            float j = clientWorld.random.nextFloat() * 0.5f + 0.35f;
            particle.setColor(red, green, blue);
            particle.quadSize = this.scale;
            particle.setAlpha(1.0f);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AnimatedFlameFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public AnimatedFlameFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            particle.spriteProviderForAnimation = this.spriteProvider;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FlameFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public FlameFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellFlameParticle particle = new SpellFlameParticle(clientWorld, d, e, f, g, h, i);
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

